/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.ImportNotRecognizedException;
import org.python.pydev.core.docutils.PyImportsHandling;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.codecompletion.AbstractPyCompletionProposalExtension2;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.importsconf.ImportsPreferencesPage;

public class CtxInsensitiveImportComplProposal
extends AbstractPyCompletionProposalExtension2
implements ICompletionProposalExtension {
    public String realImportRep;
    public String indentString;
    private int importLen = 0;
    private int newForcedOffset = -1;
    private boolean appliedWithTrigger = false;

    public CtxInsensitiveImportComplProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, String realImportRep) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, 1, "");
        this.realImportRep = realImportRep;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (viewer instanceof PySourceViewer) {
            PySourceViewer pySourceViewer = (PySourceViewer)viewer;
            PyEdit pyEdit = pySourceViewer.getEdit();
            this.indentString = pyEdit.getIndentPrefs().getIndentationString();
        } else {
            this.indentString = new DefaultIndentPrefs().getIndentationString();
        }
        this.apply(document, trigger, stateMask, offset);
    }

    public void apply(IDocument document, char trigger, int stateMask, int offset) {
        if (this.indentString == null) {
            throw new RuntimeException("Indent string not set (not called with a PyEdit as viewer?)");
        }
        if (!this.triggerCharAppliesCurrentCompletion(trigger, document, offset)) {
            this.newForcedOffset = offset + 1;
            return;
        }
        try {
            PySelection selection = new PySelection(document);
            int lineToAddImport = -1;
            ImportHandle.ImportHandleInfo groupInto = null;
            ImportHandle.ImportHandleInfo realImportHandleInfo = null;
            boolean groupImports = ImportsPreferencesPage.getGroupImports();
            if (this.realImportRep.length() > 0) {
                boolean isWithStatement = this.realImportRep.equals("from __future__ import with_statement");
                if (isWithStatement) {
                    this.fReplacementString = "with";
                }
                if (groupImports) {
                    try {
                        realImportHandleInfo = new ImportHandle.ImportHandleInfo(this.realImportRep);
                        PyImportsHandling importsHandling = new PyImportsHandling(document);
                        Iterator iterator = importsHandling.iterator();
                        block4: while (iterator.hasNext()) {
                            ImportHandle handle = (ImportHandle)iterator.next();
                            if (handle.contains(realImportHandleInfo)) {
                                lineToAddImport = -2;
                                break;
                            }
                            if (groupInto != null || realImportHandleInfo.getFromImportStr() == null) continue;
                            List handleImportInfo = handle.getImportInfo();
                            Iterator iterator2 = handleImportInfo.iterator();
                            while (iterator2.hasNext()) {
                                List commentsForImports;
                                ImportHandle.ImportHandleInfo importHandleInfo = (ImportHandle.ImportHandleInfo)iterator2.next();
                                if (!realImportHandleInfo.getFromImportStr().equals(importHandleInfo.getFromImportStr()) || (commentsForImports = importHandleInfo.getCommentsForImports()).size() <= 0 || ((String)commentsForImports.get(commentsForImports.size() - 1)).length() != 0) continue;
                                groupInto = importHandleInfo;
                                continue block4;
                            }
                        }
                    }
                    catch (ImportNotRecognizedException e1) {
                        PydevPlugin.log((Throwable)e1);
                    }
                }
                if (lineToAddImport == -1) {
                    boolean isFutureImport = PySelection.isFutureImportLine((String)this.realImportRep);
                    lineToAddImport = selection.getLineAvailableForImport(isFutureImport);
                }
            } else {
                lineToAddImport = -1;
            }
            String delimiter = PyAction.getDelimiter((IDocument)document);
            this.appliedWithTrigger = trigger == '.' || trigger == '(';
            String appendForTrigger = "";
            if (this.appliedWithTrigger) {
                if (trigger == '(') {
                    appendForTrigger = "()";
                } else if (trigger == '.') {
                    appendForTrigger = ".";
                }
            }
            if (this.fReplacementString.length() > 0) {
                int dif = offset - this.fReplacementOffset;
                document.replace(offset - dif, dif + this.fLen, String.valueOf(this.fReplacementString) + appendForTrigger);
            }
            if (groupInto != null && realImportHandleInfo != null) {
                int maxCols = 80;
                if (PydevPlugin.getDefault() != null) {
                    IPreferenceStore chainedPrefStore = PydevPrefs.getChainedPrefStore();
                    maxCols = chainedPrefStore.getInt("printMarginColumn");
                }
                int endLine = groupInto.getEndLine();
                IRegion lineInformation = document.getLineInformation(endLine);
                String strToAdd = ", " + (String)realImportHandleInfo.getImportedStr().get(0);
                String line = PySelection.getLine((IDocument)document, (int)endLine);
                if (line.length() + strToAdd.length() > maxCols) {
                    if (line.indexOf(35) == -1) {
                        int len = line.length();
                        if (line.trim().endsWith(")")) {
                            len = line.indexOf(")");
                            strToAdd = "," + delimiter + this.indentString + (String)realImportHandleInfo.getImportedStr().get(0);
                        } else {
                            strToAdd = ",\\" + delimiter + this.indentString + (String)realImportHandleInfo.getImportedStr().get(0);
                        }
                        int end = lineInformation.getOffset() + len;
                        this.importLen = strToAdd.length();
                        document.replace(end, 0, strToAdd);
                        return;
                    }
                } else {
                    line = PySelection.getLineWithoutCommentsOrLiterals((String)line);
                    int len = line.length();
                    if (line.trim().endsWith(")")) {
                        len = line.indexOf(")");
                    }
                    int end = lineInformation.getOffset() + len;
                    this.importLen = strToAdd.length();
                    document.replace(end, 0, strToAdd);
                    return;
                }
            }
            if (lineToAddImport >= 0 && lineToAddImport <= document.getNumberOfLines()) {
                IRegion lineInformation = document.getLineInformation(lineToAddImport);
                String strToAdd = String.valueOf(this.realImportRep) + delimiter;
                this.importLen = strToAdd.length();
                document.replace(lineInformation.getOffset(), 0, strToAdd);
                return;
            }
        }
        catch (BadLocationException x) {
            PydevPlugin.log((Throwable)x);
        }
    }

    public Point getSelection(IDocument document) {
        if (this.newForcedOffset >= 0) {
            return new Point(this.newForcedOffset, 0);
        }
        int pos = this.fReplacementOffset + this.fReplacementString.length() + this.importLen;
        if (this.appliedWithTrigger) {
            ++pos;
        }
        return new Point(pos, 0);
    }

    public String getInternalDisplayStringRepresentation() {
        return this.fReplacementString;
    }

    public int getOverrideBehavior(ICompletionProposal curr) {
        if (curr instanceof CtxInsensitiveImportComplProposal) {
            if (curr.getDisplayString().equals(this.getDisplayString())) {
                return 2;
            }
            return 1;
        }
        return 2;
    }
}

