/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.scopeanalysis;

import com.python.pydev.analysis.scopeanalysis.AbstractScopeAnalyzerVisitor;
import com.python.pydev.analysis.scopeanalysis.AttributeReferencesVisitor;
import com.python.pydev.analysis.scopeanalysis.TokenMatching;
import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.SequencialASTIteratorVisitor;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeAnalysis {
    public static List<ASTEntry> getAttributeReferences(String occurencesFor, SimpleNode simpleNode) {
        return ScopeAnalysis.getAttributeReferences(occurencesFor, simpleNode, AttributeReferencesVisitor.ACCEPT_ALL);
    }

    public static List<ASTEntry> getAttributeReferences(String occurencesFor, SimpleNode simpleNode, int accept) {
        ArrayList<ASTEntry> ret = new ArrayList<ASTEntry>();
        AttributeReferencesVisitor visitor = AttributeReferencesVisitor.create(simpleNode, accept);
        Iterator iterator = visitor.getNamesIterator();
        while (iterator.hasNext()) {
            ASTEntry entry = (ASTEntry)iterator.next();
            String rep = NodeUtils.getFullRepresentationString((SimpleNode)entry.node);
            if (!rep.equals(occurencesFor)) continue;
            ret.add(entry);
        }
        return ret;
    }

    public static Tuple<SimpleNode, List<ASTEntry>> getLocalOccurrences(String occurencesFor, IModule module, ILocalScope scope) {
        SimpleNode simpleNode = null;
        if (scope.getScopeStack().size() > 0) {
            simpleNode = (SimpleNode)scope.getScopeStack().peek();
        } else if (module instanceof SourceModule) {
            SourceModule m = (SourceModule)module;
            simpleNode = m.getAst();
        }
        if (simpleNode == null) {
            return new Tuple(null, new ArrayList());
        }
        return new Tuple((Object)simpleNode, ScopeAnalysis.getLocalOccurrences(occurencesFor, simpleNode));
    }

    public static List<ASTEntry> getLocalOccurrences(String occurencesFor, SimpleNode simpleNode) {
        return ScopeAnalysis.getLocalOccurrences(occurencesFor, simpleNode, true);
    }

    public static List<ASTEntry> getStringOccurrences(final String occurencesFor, SimpleNode simpleNode) {
        final ArrayList<ASTEntry> ret = new ArrayList<ASTEntry>();
        SequencialASTIteratorVisitor visitor = new SequencialASTIteratorVisitor(){

            public Object visitStr(Str node) throws Exception {
                String str = NodeUtils.getStringToPrint((Str)node);
                List<Name> names = ScopeAnalysis.checkSimpleNodeForTokenMatch(occurencesFor, new ArrayList<Name>(), (SimpleNode)node, str);
                Iterator<Name> iterator = names.iterator();
                while (iterator.hasNext()) {
                    Name name = iterator.next();
                    ASTEntry astEntryToAdd = this.atomic((SimpleNode)name);
                    astEntryToAdd.setAdditionalInfo("AST_ENTRY_FOUND_LOCATION", (Object)Autobox.valueOf((int)1));
                    ret.add(astEntryToAdd);
                }
                return super.visitStr(node);
            }
        };
        try {
            simpleNode.accept((VisitorIF)visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static List<ASTEntry> getCommentOccurrences(final String occurencesFor, SimpleNode simpleNode) {
        final ArrayList<ASTEntry> ret = new ArrayList<ASTEntry>();
        SequencialASTIteratorVisitor visitor = new SequencialASTIteratorVisitor(){

            protected Object unhandled_node(SimpleNode node) throws Exception {
                Object r = super.unhandled_node(node);
                this.checkNode(occurencesFor, ret, node);
                return r;
            }

            public Object visitClassDef(ClassDef node) throws Exception {
                Object r = super.visitClassDef(node);
                this.checkNode(occurencesFor, ret, (SimpleNode)node);
                return r;
            }

            public Object visitFunctionDef(FunctionDef node) throws Exception {
                Object r = super.visitFunctionDef(node);
                this.checkNode(occurencesFor, ret, (SimpleNode)node);
                return r;
            }

            private void checkNode(String occurencesFor2, List<ASTEntry> ret2, SimpleNode node) {
                List<Name> names = ScopeAnalysis.checkComments(node.specialsBefore, occurencesFor2);
                names.addAll(ScopeAnalysis.checkComments(node.specialsAfter, occurencesFor2));
                for (Name name : names) {
                    ASTEntry astEntryToAdd = this.atomic((SimpleNode)name);
                    astEntryToAdd.setAdditionalInfo("AST_ENTRY_FOUND_LOCATION", (Object)Autobox.valueOf((int)2));
                    ret2.add(astEntryToAdd);
                }
            }
        };
        try {
            simpleNode.accept((VisitorIF)visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static List<ASTEntry> getLocalOccurrences(String occurencesFor, SimpleNode simpleNode, final boolean onlyFirstAttribPart) {
        ret = new ArrayList<ASTEntry>();
        visitor = new SequencialASTIteratorVisitor(){

            public Object visitAttribute(Attribute node) throws Exception {
                if (onlyFirstAttribPart) {
                    AbstractScopeAnalyzerVisitor.visitNeededAttributeParts(node, (VisitorBase)this);
                    List attributeParts = NodeUtils.getAttributeParts((Attribute)node);
                    this.atomic((SimpleNode)attributeParts.get(0));
                    this.traverse((SimpleNode)attributeParts.get(0));
                    return null;
                }
                return super.visitAttribute(node);
            }
        };
        if (simpleNode instanceof FunctionDef) {
            d = (FunctionDef)simpleNode;
            try {
                if (d.decs != null) {
                    var9_7 = d.decs;
                    var8_8 = d.decs.length;
                    var7_9 = 0;
                    while (var7_9 < var8_8) {
                        dec = var9_7[var7_9];
                        if (dec != null) {
                            dec.accept((VisitorIF)visitor);
                        }
                        ++var7_9;
                    }
                }
                if (d.args != null) {
                    if (d.args.args != null) {
                        var9_7 = d.args.args;
                        var8_8 = d.args.args.length;
                        var7_9 = 0;
                        while (var7_9 < var8_8) {
                            arg = var9_7[var7_9];
                            arg.accept((VisitorIF)visitor);
                            ++var7_9;
                        }
                    }
                    if (d.args.vararg != null) {
                        d.args.vararg.accept((VisitorIF)visitor);
                    }
                    if (d.args.kwarg != null) {
                        d.args.kwarg.accept((VisitorIF)visitor);
                    }
                    if (d.args.kwonlyargs != null) {
                        var9_7 = d.args.kwonlyargs;
                        var8_8 = d.args.kwonlyargs.length;
                        var7_9 = 0;
                        while (var7_9 < var8_8) {
                            expr = var9_7[var7_9];
                            expr.accept((VisitorIF)visitor);
                            ++var7_9;
                        }
                    }
                }
                if (d.body == null) ** GOTO lbl64
                var9_7 = d.body;
                var8_8 = d.body.length;
                var7_9 = 0;
                while (var7_9 < var8_8) {
                    exp = var9_7[var7_9];
                    if (exp != null) {
                        exp.accept((VisitorIF)visitor);
                    }
                    ++var7_9;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            try {
                simpleNode.accept((VisitorIF)visitor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
lbl64:
        // 3 sources

        iterator = visitor.getNamesIterator();
        while (iterator.hasNext()) {
            entry = (ASTEntry)iterator.next();
            if (!occurencesFor.equals(entry.getName())) continue;
            ret.add(entry);
        }
        return ret;
    }

    public static List<ASTEntry> getAttributeOccurrences(String occurencesFor, SimpleNode simpleNode) {
        ArrayList<ASTEntry> ret = new ArrayList<ASTEntry>();
        SequencialASTIteratorVisitor visitor = SequencialASTIteratorVisitor.create((SimpleNode)simpleNode);
        Iterator iterator = visitor.getIterator(ClassLiteral.getClass((String)"org/python/pydev/parser/jython/ast/Attribute"));
        while (iterator.hasNext()) {
            ASTEntry entry = (ASTEntry)iterator.next();
            String rep = NodeUtils.getFullRepresentationString((SimpleNode)entry.node, (boolean)true);
            if (!rep.equals(occurencesFor)) continue;
            ret.add(entry);
        }
        return ret;
    }

    public static List<Name> checkComments(List<Object> specials, String match) {
        ArrayList<Name> r = new ArrayList<Name>();
        if (specials != null) {
            for (Object s : specials) {
                if (!(s instanceof commentType)) continue;
                commentType comment = (commentType)s;
                ScopeAnalysis.checkSimpleNodeForTokenMatch(match, r, (SimpleNode)comment, comment.id);
            }
        }
        return r;
    }

    public static List<Name> checkSimpleNodeForTokenMatch(String match, List<Name> ret, SimpleNode node, String fullString) {
        try {
            ArrayList<Integer> offsets = TokenMatching.getMatchOffsets(match, fullString);
            List lineStartOffsets = PySelection.getLineStartOffsets((String)fullString);
            for (Integer offset : offsets) {
                int line = 0;
                Name name = new Name(match, 7, false);
                for (Integer lineStartOffset : lineStartOffsets) {
                    if (line == 0 && lineStartOffset > 0) {
                        line = 1;
                    }
                    if (lineStartOffset > offset) break;
                    name.beginLine = node.beginLine + line;
                    name.beginColumn = line == 0 ? node.beginColumn + offset - lineStartOffset : offset - lineStartOffset + 1;
                    ++line;
                }
                ret.add(name);
            }
        }
        catch (CoreException e) {
            PydevPlugin.log((Throwable)e);
        }
        return ret;
    }
}

