/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.compare;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PyPartitionScanner;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PyEditConfiguration;
import org.python.pydev.editor.PyEditConfigurationWithoutEditor;
import org.python.pydev.editor.actions.FirstCharAction;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.PyBackspace;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.ColorAndStyleCache;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyMergeViewer
extends TextMergeViewer {
    private List<ColorAndStyleCache> colorCache;
    private List<IPropertyChangeListener> prefChangeListeners;

    public PyMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(parent, style | 0x2000000, configuration);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return PyPartitionScanner.createPyPartitioner();
    }

    protected String getDocumentPartitioning() {
        return "__PYTHON_PARTITION_TYPE";
    }

    private IPythonNature getPythonNature(Object compareInput) {
        IResource resource = this.getResource(compareInput);
        if (resource != null) {
            return PythonNature.getPythonNature(resource);
        }
        return null;
    }

    private IResource getResource(Object compareInput) {
        if (!(compareInput instanceof ICompareInput)) {
            return null;
        }
        ICompareInput input = (ICompareInput)compareInput;
        if (input == null) {
            // empty if block
        }
        IResourceProvider rp = null;
        ITypedElement te = input.getLeft();
        if (te instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getRight()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp == null && (te = input.getAncestor()) instanceof IResourceProvider) {
            rp = (IResourceProvider)te;
        }
        if (rp != null) {
            return rp.getResource();
        }
        return null;
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        SourceViewer viewer = super.createSourceViewer(parent, textOrientation);
        viewer.appendVerifyKeyListener(PyBackspace.createVerifyKeyListener((TextViewer)viewer, null));
        IWorkbenchPart workbenchPart = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        IWorkbenchPartSite site = null;
        if (workbenchPart != null) {
            site = workbenchPart.getSite();
        } else {
            IWorkbenchPart activePart;
            IWorkbenchPage activePage;
            IWorkbenchWindow window = PyAction.getActiveWorkbenchWindow();
            if (window != null && (activePage = window.getActivePage()) != null && (activePart = activePage.getActivePart()) != null) {
                site = activePart.getSite();
            }
        }
        VerifyKeyListener createVerifyKeyListener = FirstCharAction.createVerifyKeyListener(viewer, site, true);
        if (createVerifyKeyListener != null) {
            viewer.appendVerifyKeyListener(createVerifyKeyListener);
        }
        return viewer;
    }

    private List<ColorAndStyleCache> getColorCache() {
        if (this.colorCache == null) {
            this.colorCache = new ArrayList<ColorAndStyleCache>();
        }
        return this.colorCache;
    }

    public List<IPropertyChangeListener> getPrefChangeListeners() {
        if (this.prefChangeListeners == null) {
            this.prefChangeListeners = new ArrayList<IPropertyChangeListener>();
        }
        return this.prefChangeListeners;
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (!(textViewer instanceof SourceViewer)) {
            return;
        }
        final SourceViewer sourceViewer = (SourceViewer)textViewer;
        final DefaultIndentPrefs indentPrefs = new DefaultIndentPrefs();
        final WeakReference[] sourceViewerConfigurationObj = new WeakReference[1];
        IPreferenceStore chainedPrefStore = PydevPrefs.getChainedPrefStore();
        final ColorAndStyleCache c = new ColorAndStyleCache(chainedPrefStore);
        this.getColorCache().add(c);
        IPySyntaxHighlightingAndCodeCompletionEditor editor = new IPySyntaxHighlightingAndCodeCompletionEditor(){

            public void resetForceTabs() {
            }

            public IIndentPrefs getIndentPrefs() {
                return indentPrefs;
            }

            public ISourceViewer getEditorSourceViewer() {
                return sourceViewer;
            }

            public PyEditConfigurationWithoutEditor getEditConfiguration() {
                return (PyEditConfigurationWithoutEditor)((Object)sourceViewerConfigurationObj[0].get());
            }

            public ColorAndStyleCache getColorCache() {
                return c;
            }

            public PySelection createPySelection() {
                ISelection selection = sourceViewer.getSelection();
                if (selection instanceof ITextSelection) {
                    return new PySelection(sourceViewer.getDocument(), (ITextSelection)selection);
                }
                return null;
            }

            public File getEditorFile() {
                IResource file = PyMergeViewer.this.getResource(PyMergeViewer.this.getInput());
                if (file != null && file instanceof IFile) {
                    IPath path = file.getLocation().makeAbsolute();
                    return path.toFile();
                }
                return null;
            }

            public IPythonNature getPythonNature() throws MisconfigurationException {
                return PyMergeViewer.this.getPythonNature(PyMergeViewer.this.getInput());
            }

            public Object getAdapter(Class adapter) {
                IResource resource;
                if (adapter == ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource")) {
                    return PyMergeViewer.this.getResource(PyMergeViewer.this.getInput());
                }
                if (adapter == ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile") && (resource = PyMergeViewer.this.getResource(PyMergeViewer.this.getInput())) instanceof IFile) {
                    return resource;
                }
                return null;
            }
        };
        PyEditConfiguration sourceViewerConfiguration = new PyEditConfiguration(c, editor, chainedPrefStore);
        sourceViewerConfigurationObj[0] = new WeakReference<PyEditConfiguration>(sourceViewerConfiguration);
        sourceViewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        IPropertyChangeListener prefChangeListener = PyEdit.createPrefChangeListener(editor);
        this.getPrefChangeListeners().add(prefChangeListener);
        chainedPrefStore.addPropertyChangeListener(prefChangeListener);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        List<ColorAndStyleCache> colorCache = this.getColorCache();
        for (ColorAndStyleCache c : colorCache) {
            c.dispose();
        }
        colorCache.clear();
        List<IPropertyChangeListener> prefChangeListeners = this.getPrefChangeListeners();
        for (IPropertyChangeListener l : prefChangeListeners) {
            PydevPrefs.getChainedPrefStore().removePropertyChangeListener(l);
        }
        prefChangeListeners.clear();
    }
}

