/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.python.pydev.navigator.actions.PyCopyResourceAction;
import org.python.pydev.navigator.actions.PyDeleteResourceAction;
import org.python.pydev.navigator.actions.PyMoveResourceAction;
import org.python.pydev.navigator.actions.PyOpenExternalAction;
import org.python.pydev.navigator.actions.PyOpenPythonFileAction;
import org.python.pydev.navigator.actions.PyOpenResourceAction;
import org.python.pydev.navigator.actions.PyPasteAction;

public class PythonActionProvider
extends CommonActionProvider {
    private PyOpenPythonFileAction openPythonAction;
    private PyOpenResourceAction openResourceAction;
    private PyOpenExternalAction openExternalAction;
    private PyDeleteResourceAction deleteResourceAction;
    private PyCopyResourceAction copyResourceAction;
    private Clipboard clipboard;
    private PyPasteAction pasteAction;
    private PyMoveResourceAction moveResourceAction;
    private ISelectionProvider selectionProvider;

    public void init(ICommonActionExtensionSite aSite) {
        ICommonViewerSite viewSite = aSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite site = (ICommonViewerWorkbenchSite)viewSite;
            Shell shell = site.getShell();
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.clipboard = new Clipboard(shell.getDisplay());
            this.selectionProvider = site.getSelectionProvider();
            this.openPythonAction = new PyOpenPythonFileAction(site.getPage(), this.selectionProvider);
            this.openResourceAction = new PyOpenResourceAction(site.getPage(), this.selectionProvider);
            this.openExternalAction = new PyOpenExternalAction(site.getPage(), this.selectionProvider);
            this.deleteResourceAction = new PyDeleteResourceAction(shell, this.selectionProvider);
            this.copyResourceAction = new PyCopyResourceAction(shell, this.selectionProvider, this.clipboard);
            this.pasteAction = new PyPasteAction(shell, this.selectionProvider, this.clipboard);
            this.moveResourceAction = new PyMoveResourceAction(shell, this.selectionProvider);
            this.copyResourceAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            this.copyResourceAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
            this.pasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
            this.pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
            this.deleteResourceAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            this.deleteResourceAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openResourceAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openResourceAction);
        }
        if (this.copyResourceAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyResourceAction);
        }
        if (this.pasteAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        }
        if (this.deleteResourceAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteResourceAction);
        }
        if (this.moveResourceAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveResourceAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.openResourceAction.isEnabledForSelectionWithoutContainers()) {
            menu.appendToGroup("group.open", (IAction)this.openResourceAction);
        }
        if (this.openPythonAction.isEnabledForSelectionWithoutContainers()) {
            menu.appendToGroup("group.open", (IAction)this.openPythonAction);
        }
        if (this.openExternalAction.isEnabledForSelectionWithoutContainers()) {
            menu.appendToGroup("group.open", (IAction)this.openExternalAction);
        }
        if (this.copyResourceAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.copyResourceAction);
        }
        if (this.pasteAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.pasteAction);
        }
        if (this.deleteResourceAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.deleteResourceAction);
        }
        if (this.moveResourceAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.moveResourceAction);
        }
    }
}

