/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.cache;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.python.pydev.core.cache.Cache;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<Key, Val>
implements Cache<Key, Val>,
Serializable {
    protected int maxSize;
    private static final long serialVersionUID = 1L;
    protected LinkedHashMap<Key, Val> cache;

    public LRUCache(int maxSize) {
        this.maxSize = maxSize;
        this.cache = this.createMap(maxSize);
    }

    protected LinkedHashMap<Key, Val> createMap(int maxSize) {
        return new LinkedHashMap<Key, Val>(maxSize + 1, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCache.this.maxSize;
            }
        };
    }

    @Override
    public Val getObj(Key key) {
        return this.cache.get(key);
    }

    @Override
    public void remove(Key key) {
        this.cache.remove(key);
    }

    @Override
    public void add(Key key, Val val) {
        this.cache.put(key, val);
    }

    public void clear() {
        this.cache.clear();
    }
}

