/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django_templates.comon.parsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.python.pydev.django_templates.common.parsing.lexer.DjangoTemplatesTokens;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DjTokenScanner {
    private static final String[] DJ_START = new String[]{"{%", "{{"};
    private static final String[] DJ_END = new String[]{"%}", "}}"};

    public List<IRule> getDjRules() {
        String word;
        ArrayList<IRule> rules = new ArrayList<IRule>();
        WordRule wordRule = new WordRule((IWordDetector)new DjStartDetector(), Token.UNDEFINED);
        IToken token = this.createToken(DjTokenScanner.getTokenName((short)101));
        String[] stringArray = DJ_START;
        int n = DJ_START.length;
        int n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            wordRule.addWord(word, token);
            ++n2;
        }
        rules.add((IRule)wordRule);
        wordRule = new WordRule((IWordDetector)new DjEndDetector(), Token.UNDEFINED);
        token = this.createToken(DjTokenScanner.getTokenName((short)102));
        stringArray = DJ_END;
        n = DJ_END.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            wordRule.addWord(word, token);
            ++n2;
        }
        rules.add((IRule)wordRule);
        return rules;
    }

    protected IToken createToken(String string) {
        return new Token((Object)string);
    }

    private static String getTokenName(short token) {
        return DjangoTemplatesTokens.getTokenName(token);
    }

    private static final class DjEndDetector
    implements IWordDetector {
        private DjEndDetector() {
        }

        public boolean isWordPart(char c) {
            switch (c) {
                case '%': 
                case '}': {
                    return true;
                }
            }
            return false;
        }

        public boolean isWordStart(char c) {
            return c == '}' || c == '%';
        }
    }

    private static final class DjStartDetector
    implements IWordDetector {
        private DjStartDetector() {
        }

        public boolean isWordPart(char c) {
            switch (c) {
                case '%': 
                case '{': {
                    return true;
                }
            }
            return false;
        }

        public boolean isWordStart(char c) {
            return c == '{';
        }
    }
}

