/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.interactiveconsole;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.debug.newconsole.PydevConsole;
import org.python.pydev.debug.newconsole.PydevConsoleFactory;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.internal.ScriptConsoleViewer;
import org.python.pydev.editor.IPyEditListener;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.runners.SimpleRunner;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluateActionSetter
implements IPyEditListener {
    private static final String EVALUATE_ACTION_ID = "org.python.pydev.interactiveconsole.evaluateActionSetter";

    private ScriptConsole getActiveScriptConsole(String consoleType) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            List<IViewPart> consoleParts = this.getConsoleParts(page, false);
            if (consoleParts.size() == 0) {
                consoleParts = this.getConsoleParts(page, true);
            }
            if (consoleParts.size() > 0) {
                IConsole console;
                IConsoleView view = null;
                long lastChangeMillis = Long.MIN_VALUE;
                if (consoleParts.size() == 1) {
                    view = (IConsoleView)consoleParts.get(0);
                } else {
                    int i = 0;
                    while (i < consoleParts.size()) {
                        PydevConsole tempConsole;
                        ScriptConsoleViewer viewer;
                        long tempLastChangeMillis;
                        IConsoleView temp = (IConsoleView)consoleParts.get(i);
                        IConsole console2 = temp.getConsole();
                        if (console2 instanceof PydevConsole && (tempLastChangeMillis = (viewer = (tempConsole = (PydevConsole)console2).getViewer()).getLastChangeMillis()) > lastChangeMillis) {
                            lastChangeMillis = tempLastChangeMillis;
                            view = temp;
                        }
                        ++i;
                    }
                }
                if (view != null && (console = view.getConsole()) instanceof ScriptConsole && console.getType().equals(consoleType)) {
                    return (ScriptConsole)console;
                }
            }
        }
        return null;
    }

    private List<IViewPart> getConsoleParts(IWorkbenchPage page, boolean restore) {
        IViewReference[] viewReferences;
        ArrayList<IViewPart> consoleParts = new ArrayList<IViewPart>();
        IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart part;
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals("org.eclipse.ui.console.ConsoleView") && (part = ref.getView(restore)) != null) {
                consoleParts.add(part);
                if (restore) {
                    return consoleParts;
                }
            }
            ++n2;
        }
        return consoleParts;
    }

    public void onCreateActions(ListResourceBundle resources, final PyEdit edit, IProgressMonitor monitor) {
        final EvaluateAction evaluateAction = new EvaluateAction(edit);
        evaluateAction.setActionDefinitionId(EVALUATE_ACTION_ID);
        evaluateAction.setId(EVALUATE_ACTION_ID);
        Runnable runnable = new Runnable(){

            public void run() {
                if (!edit.isDisposed()) {
                    edit.setAction(EvaluateActionSetter.EVALUATE_ACTION_ID, (IAction)evaluateAction);
                }
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    public void onSave(PyEdit edit, IProgressMonitor monitor) {
    }

    public void onDispose(PyEdit edit, IProgressMonitor monitor) {
    }

    public void onSetDocument(IDocument document, PyEdit edit, IProgressMonitor monitor) {
    }

    private class EvaluateAction
    extends Action {
        private final PyEdit edit;

        private EvaluateAction(PyEdit edit) {
            this.edit = edit;
        }

        public void run() {
            try {
                PySelection selection = new PySelection((ITextEditor)this.edit);
                ScriptConsole console = EvaluateActionSetter.this.getActiveScriptConsole("org.python.pydev.debug.newconsole.PydevConsole");
                if (console == null) {
                    PydevConsoleFactory factory = new PydevConsoleFactory();
                    console = factory.createConsole();
                }
                if (console instanceof PydevConsole) {
                    PydevConsole pydevConsole = (PydevConsole)console;
                    IDocument document = pydevConsole.getDocument();
                    String code = selection.getTextSelection().getText();
                    if (code.length() != 0) {
                        document.replace(document.getLength(), 0, String.valueOf(code) + "\n");
                    } else {
                        File editorFile = this.edit.getEditorFile();
                        if (editorFile != null) {
                            String fileStr = SimpleRunner.getArgumentsAsStr((String[])new String[]{editorFile.toString()}, (String[])new String[0]);
                            char[] characters = fileStr.trim().toCharArray();
                            FastStringBuffer buf = new FastStringBuffer(characters.length + characters.length / 2);
                            int i = 0;
                            while (i < characters.length) {
                                char character = characters[i];
                                if (character == '\\') {
                                    buf.append("\\");
                                }
                                buf.append(character);
                                ++i;
                            }
                            if (buf.startsWith('\"')) {
                                buf.deleteFirst();
                            }
                            if (buf.endsWith('\"')) {
                                buf.deleteLast();
                            }
                            document.replace(document.getLength(), 0, StringUtils.format((String)"execfile('%s')\n", (Object[])new Object[]{buf.toString()}));
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }
}

