/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolox.util.MutablePoints;
import edu.umd.cs.piccolox.util.Points;
import edu.umd.cs.piccolox.util.XYArray;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LineShape
implements Shape,
MutablePoints {
    private MutablePoints points;
    private Rectangle2D bounds = new Rectangle2D.Double();

    public LineShape(MutablePoints points) {
        this.setPoints(points);
    }

    public void setPoints(MutablePoints points) {
        if (points == null) {
            points = new XYArray();
        }
        this.points = points;
    }

    public int getPointCount() {
        return this.points.getPointCount();
    }

    public double getX(int i) {
        return this.points.getX(i);
    }

    public double getY(int i) {
        return this.points.getY(i);
    }

    public Point2D getPoint(int i, Point2D dst) {
        return this.points.getPoint(i, dst);
    }

    public Rectangle2D getBounds(Rectangle2D dst) {
        this.points.getBounds(dst);
        return dst;
    }

    public void updateBounds() {
        this.bounds.setRect(0.0, 0.0, 0.0, 0.0);
        this.points.getBounds(this.bounds);
    }

    public void setPoint(int i, double x, double y) {
        this.points.setPoint(i, x, y);
        this.updateBounds();
    }

    public void addPoint(int pos, double x, double y) {
        this.points.addPoint(pos, x, y);
        this.updateBounds();
    }

    public void removePoints(int pos, int num) {
        this.points.removePoints(pos, num);
        this.updateBounds();
    }

    public void transformPoints(AffineTransform trans) {
        XYArray newPoints = new XYArray(this.points.getPointCount());
        newPoints.appendPoints(this.points);
        newPoints.transformPoints(trans);
        this.points = newPoints;
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.bounds.getX(), (int)this.bounds.getY(), (int)this.bounds.getWidth(), (int)this.bounds.getHeight());
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public static boolean contains(double x, double y, double x1, double y1, double x2, double y2, boolean min, boolean max, double d) {
        double p;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        if (dx != 0.0) {
            p = ((x - x1) / dx + dy * (y - y1) / dx2) / (1.0 + dy2 / dx2);
        } else if (dy != 0.0) {
            p = ((y - y1) / dy + dx * (x - x1) / dy2) / (1.0 + dx2 / dy2);
        } else {
            return false;
        }
        if (max && p > 1.0) {
            return false;
        }
        if (min && p < 0.0) {
            return false;
        }
        double len = (dx = p * dx + x1 - x) * dx + (dy = p * dy + y1 - y) * dy;
        return len < d;
    }

    public boolean contains(double x, double y, double d) {
        if (this.points.getPointCount() == 0) {
            return false;
        }
        double x2 = this.points.getX(0);
        double y2 = this.points.getX(0);
        int i = 0;
        while (i < this.points.getPointCount()) {
            double x1 = x2;
            double y1 = y2;
            if (LineShape.contains(x, y, x1, y1, x2 = this.points.getX(i), y2 = this.points.getX(i), false, false, d)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(double x, double y) {
        return this.contains(x, y, 2.0);
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public static boolean intersects(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, boolean min1, boolean max1, boolean min2, boolean max2) {
        double p1;
        double p2;
        double dx1 = x2 - x1;
        double dy1 = y2 - y1;
        double dx2 = x4 - x3;
        double dy2 = y4 - y3;
        if (dy1 != 0.0) {
            double d = dx1 / dy1;
            p2 = (x3 - x1 + d * (y1 - y3)) / (d * dy2 - dx2);
            p1 = (dy2 * p2 + y3 - y1) / dy1;
        } else if (dy2 != 0.0) {
            double d = dx2 / dy2;
            p1 = (x1 - x3 + d * (y3 - y1)) / (d * dy1 - dx1);
            p2 = (dy1 * p1 + y1 - y3) / dy2;
        } else if (dx1 != 0.0) {
            double d = dy1 / dx1;
            p2 = (y3 - y1 + d * (x1 - x3)) / (d * dx2 - dy2);
            p1 = (dx2 * p2 + x3 - x1) / dx1;
        } else if (dx2 != 0.0) {
            double d = dy2 / dx2;
            p1 = (y1 - y3 + d * (x3 - x1)) / (d * dx1 - dy1);
            p2 = (dx1 * p1 + x1 - x3) / dx2;
        } else {
            return false;
        }
        return !(min1 && !(p1 >= 0.0) || max1 && !(p1 <= 1.0) || min2 && !(p2 >= 0.0) || max2 && !(p2 <= 1.0));
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.points.getPointCount() == 0) {
            return false;
        }
        double x2 = this.points.getX(0);
        double y2 = this.points.getX(0);
        int i = 0;
        while (i < this.points.getPointCount()) {
            double x1 = x2;
            double y1 = y2;
            if (LineShape.intersects(x, y, x + w, y, x1, y1, x2 = this.points.getX(i), y2 = this.points.getX(i), true, true, true, true) || LineShape.intersects(x + w, y, x + w, y + h, x1, y1, x2, y2, true, true, true, true) || LineShape.intersects(x + w, y + h, x, y + h, x1, y1, x2, y2, true, true, true, true) || LineShape.intersects(x, y + h, x, y, x1, y1, x2, y2, true, true, true, true)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new LinePathIterator(this.points, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new LinePathIterator(this.points, at);
    }

    private static class LinePathIterator
    implements PathIterator {
        private Points points;
        private AffineTransform trans;
        private int i = 0;
        private Point2D tempPoint = new Point2D.Double();

        public LinePathIterator(Points points, AffineTransform trans) {
            this.points = points;
            this.trans = trans;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.i >= this.points.getPointCount();
        }

        public void next() {
            ++this.i;
        }

        private void currentSegment() {
            this.tempPoint.setLocation(this.points.getX(this.i), this.points.getY(this.i));
            if (this.trans != null) {
                this.trans.transform(this.tempPoint, this.tempPoint);
            }
        }

        public int currentSegment(float[] coords) {
            this.currentSegment();
            coords[0] = (float)this.tempPoint.getX();
            coords[1] = (float)this.tempPoint.getY();
            return this.i == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            this.currentSegment();
            coords[0] = this.tempPoint.getX();
            coords[1] = this.tempPoint.getY();
            return this.i == 0 ? 0 : 1;
        }
    }
}

