/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.outline.AbstractOutlineFilterAction;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;

public class OutlineHideNonPublicMembersAction
extends AbstractOutlineFilterAction {
    private static final String PREF_HIDE_NONPUBLICMEMBERS = "org.python.pydev.OUTLINE_HIDE_NONPUBLICMEMBERS";

    public OutlineHideNonPublicMembersAction(PyOutlinePage page, ImageCache imageCache) {
        super("Hide Non-Public Members", page, imageCache, PREF_HIDE_NONPUBLICMEMBERS, "icons/new/attrpub_obj.gif");
    }

    protected ViewerFilter createFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ParsedItem) {
                    ASTEntryWithChildren astThis;
                    ParsedItem item = (ParsedItem)element;
                    if (item == null) {
                        // empty if block
                    }
                    if ((astThis = item.getAstThis()) == null) {
                        return true;
                    }
                    SimpleNode token = astThis.node;
                    if (token == null) {
                        return true;
                    }
                    String name = NodeUtils.getRepresentationString((SimpleNode)token);
                    if (name != null) {
                        return !name.startsWith("_") || name.startsWith("__") && name.endsWith("__");
                    }
                }
                return true;
            }
        };
    }
}

