/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.indexview;

import com.python.pydev.analysis.indexview.ElementWithChildren;
import com.python.pydev.analysis.indexview.ITreeElement;
import com.python.pydev.analysis.indexview.LeafElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.editor.codecompletion.revisited.SystemModulesManager;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class ForcedLibGroup
extends ElementWithChildren {
    private InterpreterInfo interpreterInfo;
    private String forcedLib;

    public ForcedLibGroup(ITreeElement parent, InterpreterInfo interpreterInfo, String forcedLib) {
        super(parent);
        this.interpreterInfo = interpreterInfo;
        this.forcedLib = forcedLib;
    }

    public boolean hasChildren() {
        return true;
    }

    protected void calculateChildren() throws MisconfigurationException {
        SystemModulesManager m = (SystemModulesManager)this.interpreterInfo.getModulesManager();
        AbstractModule builtinModule = m.getBuiltinModule(this.forcedLib, m.getNature(), true);
        IToken[] globalTokens = builtinModule.getGlobalTokens();
        ArrayList<LeafElement> lst = new ArrayList<LeafElement>();
        IToken[] iTokenArray = globalTokens;
        int n = globalTokens.length;
        int n2 = 0;
        while (n2 < n) {
            IToken iToken = iTokenArray[n2];
            lst.add(new LeafElement(this, iToken.getRepresentation()));
            ++n2;
        }
        Collections.sort(lst, new Comparator<LeafElement>(){

            @Override
            public int compare(LeafElement o1, LeafElement o2) {
                return o1.toString().compareTo(o2.toString());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((LeafElement)object, (LeafElement)object2);
            }
        });
        Iterator iterator = lst.iterator();
        while (iterator.hasNext()) {
            LeafElement leafElement = (LeafElement)iterator.next();
            this.addChild(leafElement);
        }
    }

    public String toString() {
        return "Forced builtin: " + this.forcedLib;
    }
}

