/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ExtraMath;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyFloat;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class PyComplex
extends PyObject {
    static PyComplex J = new PyComplex(0.0, 1.0);
    public static PyClass __class__;
    public double real;
    public double imag;

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'complex' object";
    }

    public static String toString(double value) {
        if (value == Math.floor(value) && value <= 9.223372036854776E18 && value >= -9.223372036854776E18) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    public String toString() {
        if (this.real == 0.0) {
            return PyComplex.toString(this.imag) + "j";
        }
        if (this.imag >= 0.0) {
            return "(" + PyComplex.toString(this.real) + "+" + PyComplex.toString(this.imag) + "j)";
        }
        return "(" + PyComplex.toString(this.real) + "-" + PyComplex.toString(-this.imag) + "j)";
    }

    public int hashCode() {
        if (this.imag == 0.0) {
            return new PyFloat(this.real).hashCode();
        }
        long v = Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.imag);
        return (int)v ^ (int)(v >> 32);
    }

    public boolean __nonzero__() {
        return this.real != 0.0 && this.imag != 0.0;
    }

    public int __cmp__(PyObject other) {
        double oreal = ((PyComplex)other).real;
        double oimag = ((PyComplex)other).imag;
        if (this.real == oreal && this.imag == oimag) {
            return 0;
        }
        if (this.real != oreal) {
            return this.real < oreal ? -1 : 1;
        }
        return this.imag < oimag ? -1 : 1;
    }

    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyComplex) {
            return other;
        }
        if (other instanceof PyFloat) {
            return new PyComplex(((PyFloat)other).getValue(), 0.0);
        }
        if (other instanceof PyInteger) {
            return new PyComplex(((PyInteger)other).getValue(), 0.0);
        }
        if (other instanceof PyLong) {
            return new PyComplex(((PyLong)other).doubleValue(), 0.0);
        }
        return Py.None;
    }

    private final boolean canCoerce(PyObject other) {
        return other instanceof PyComplex || other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private final PyComplex coerce(PyObject other) {
        if (other instanceof PyComplex) {
            return (PyComplex)other;
        }
        if (other instanceof PyFloat) {
            return new PyComplex(((PyFloat)other).getValue(), 0.0);
        }
        if (other instanceof PyInteger) {
            return new PyComplex(((PyInteger)other).getValue(), 0.0);
        }
        if (other instanceof PyLong) {
            return new PyComplex(((PyLong)other).doubleValue(), 0.0);
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        PyComplex c = this.coerce(right);
        return new PyComplex(this.real + c.real, this.imag + c.imag);
    }

    public PyObject __radd__(PyObject left) {
        return this.__add__(left);
    }

    private static final PyObject _sub(PyComplex o1, PyComplex o2) {
        return new PyComplex(o1.real - o2.real, o1.imag - o2.imag);
    }

    public PyObject __sub__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._sub(this, this.coerce(right));
    }

    public PyObject __rsub__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._sub(this.coerce(left), this);
    }

    private static final PyObject _mul(PyComplex o1, PyComplex o2) {
        return new PyComplex(o1.real * o2.real - o1.imag * o2.imag, o1.real * o2.imag + o1.imag * o2.real);
    }

    public PyObject __mul__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._mul(this, this.coerce(right));
    }

    public PyObject __rmul__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._mul(this.coerce(left), this);
    }

    private static final PyObject _div(PyComplex a, PyComplex b) {
        double abs_bimag;
        double abs_breal = b.real < 0.0 ? -b.real : b.real;
        double d = abs_bimag = b.imag < 0.0 ? -b.imag : b.imag;
        if (abs_breal >= abs_bimag) {
            if (abs_breal == 0.0) {
                throw Py.ZeroDivisionError("complex division");
            }
            double ratio = b.imag / b.real;
            double denom = b.real + b.imag * ratio;
            return new PyComplex((a.real + a.imag * ratio) / denom, (a.imag - a.real * ratio) / denom);
        }
        double ratio = b.real / b.imag;
        double denom = b.real * ratio + b.imag;
        return new PyComplex((a.real * ratio + a.imag) / denom, (a.imag * ratio - a.real) / denom);
    }

    public PyObject __div__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._div(this, this.coerce(right));
    }

    public PyObject __rdiv__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._div(this.coerce(left), this);
    }

    public PyObject __mod__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._mod(this, this.coerce(right));
    }

    public PyObject __rmod__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._mod(this.coerce(left), this);
    }

    private static final PyObject _mod(PyComplex value, PyComplex right) {
        PyComplex z = (PyComplex)value.__div__(right);
        z.real = Math.floor(z.real);
        z.imag = 0.0;
        return value.__sub__(z.__mul__(right));
    }

    public PyObject __divmod__(PyObject right) {
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(right));
    }

    public PyObject __rdivmod__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(left), this);
    }

    private static final PyObject _divmod(PyComplex value, PyComplex right) {
        PyComplex z = (PyComplex)value.__div__(right);
        z.real = Math.floor(z.real);
        z.imag = 0.0;
        return new PyTuple(new PyObject[]{z, value.__sub__(z.__mul__(right))});
    }

    private static final PyObject ipow(PyComplex value, int iexp) {
        int pow = iexp;
        if (pow < 0) {
            pow = -pow;
        }
        double xr = value.real;
        double xi = value.imag;
        double zr = 1.0;
        double zi = 0.0;
        while (pow > 0) {
            double tmp;
            if ((pow & 1) != 0) {
                tmp = zr * xr - zi * xi;
                zi = zi * xr + zr * xi;
                zr = tmp;
            }
            if ((pow >>= 1) == 0) break;
            tmp = xr * xr - xi * xi;
            xi = xr * xi * 2.0;
            xr = tmp;
        }
        PyComplex ret = new PyComplex(zr, zi);
        if (iexp < 0) {
            return new PyComplex(1.0, 0.0).__div__(ret);
        }
        return ret;
    }

    public PyObject __pow__(PyObject right, PyObject modulo) {
        if (modulo != null) {
            throw Py.ValueError("complex modulo");
        }
        if (!this.canCoerce(right)) {
            return null;
        }
        return PyComplex._pow(this, this.coerce(right));
    }

    public PyObject __rpow__(PyObject left) {
        if (!this.canCoerce(left)) {
            return null;
        }
        return PyComplex._pow(this.coerce(left), this);
    }

    public static PyObject _pow(PyComplex value, PyComplex right) {
        double xr = value.real;
        double xi = value.imag;
        double yr = right.real;
        double yi = right.imag;
        if (yr == 0.0 && yi == 0.0) {
            return new PyComplex(1.0, 0.0);
        }
        if (xr == 0.0 && xi == 0.0 && (yi != 0.0 || yr < 0.0)) {
            throw Py.ValueError("0.0 to a negative or complex power");
        }
        int iexp = (int)yr;
        if (yi == 0.0 && yr == (double)iexp && iexp >= -128 && iexp <= 128) {
            return PyComplex.ipow(value, iexp);
        }
        double abs = ExtraMath.hypot(xr, xi);
        double len = Math.pow(abs, yr);
        double at = Math.atan2(xi, xr);
        double phase = at * yr;
        if (yi != 0.0) {
            len /= Math.exp(at * yi);
            phase += yi * Math.log(abs);
        }
        return new PyComplex(len * Math.cos(phase), len * Math.sin(phase));
    }

    public PyObject __neg__() {
        return new PyComplex(-this.real, -this.imag);
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __abs__() {
        return new PyFloat(ExtraMath.hypot(this.real, this.imag));
    }

    public PyInteger __int__() {
        throw Py.TypeError("can't convert complex to int; use e.g. int(abs(z))");
    }

    public PyLong __long__() {
        throw Py.TypeError("can't convert complex to long; use e.g. long(abs(z))");
    }

    public PyFloat __float__() {
        throw Py.TypeError("can't convert complex to float; use e.g. abs(z)");
    }

    public PyComplex __complex__() {
        return this;
    }

    public PyComplex conjugate() {
        return new PyComplex(this.real, -this.imag);
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    public PyComplex(double r, double i) {
        this.real = r;
        this.imag = i;
    }
}

