/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.editor.codecompletion.revisited.ModulesKeyTreeMap;
import org.python.pydev.editor.codecompletion.revisited.ModulesManagerCache;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JythonModulesManagerUtils;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModuleForZip;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModulesManager
implements IModulesManager,
Serializable {
    private static final boolean DEBUG_BUILD = false;
    private static final boolean DEBUG_TEMPORARY_MODULES = false;
    private static final boolean DEBUG_IO = false;
    private static final boolean DEBUG_ZIP = false;
    protected volatile transient CompletionCache completionCache = null;
    protected transient Object lockCompletionCache = new Object();
    private volatile transient int completionCacheI = 0;
    protected transient ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeys = new ModulesKeyTreeMap();
    protected static transient ModulesManagerCache cache = new ModulesManagerCache();
    protected transient Set<File> files = new HashSet<File>();
    protected PythonPathHelper pythonPathHelper = new PythonPathHelper();
    private static final long serialVersionUID = 2L;
    public volatile transient Map<String, FastStack<IModule>> temporaryModules = null;
    private transient Object lockTemporaryModules = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startCompletionCache() {
        Object object = this.lockCompletionCache;
        synchronized (object) {
            if (this.completionCache == null) {
                this.completionCache = new CompletionCache();
            }
            ++this.completionCacheI;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCompletionCache() {
        Object object = this.lockCompletionCache;
        synchronized (object) {
            --this.completionCacheI;
            if (this.completionCacheI == 0) {
                this.completionCache = null;
            } else if (this.completionCacheI < 0) {
                throw new RuntimeException("Completion cache negative (request unsynched)");
            }
        }
    }

    public PythonPathHelper getPythonPathHelper() {
        return this.pythonPathHelper;
    }

    public void setPythonPathHelper(Object pathHelper) {
        if (!(pathHelper instanceof PythonPathHelper)) {
            throw new IllegalArgumentException();
        }
        this.pythonPathHelper = (PythonPathHelper)pathHelper;
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        this.lockCompletionCache = new Object();
        this.lockTemporaryModules = new Object();
        this.modulesKeys = new ModulesKeyTreeMap();
        this.files = new HashSet<File>();
        aStream.defaultReadObject();
        Set set = (Set)aStream.readObject();
        for (ModulesKey key : set) {
            this.modulesKeys.put(key, key);
            if (key.file == null) continue;
            this.files.add(key.file);
        }
        if (this.pythonPathHelper == null) {
            throw new IOException(new StringBuffer("Pythonpath helper not properly restored. ").append(this.getClass().getName()).toString());
        }
        if (this.pythonPathHelper.getPythonpath() == null) {
            throw new IOException(new StringBuffer("Pythonpath helper pythonpath not properly restored. ").append(this.getClass().getName()).toString());
        }
        if (this.pythonPathHelper.getPythonpath().size() == 0) {
            throw new IOException(new StringBuffer("Pythonpath helper pythonpath restored with no contents. ").append(this.getClass().getName()).toString());
        }
        if (set.size() < 15) {
            throw new IOException(new StringBuffer("Only ").append(set.size()).append(" modules restored in I/O. ").append(this.getClass().getName()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream aStream) throws IOException {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            aStream.defaultWriteObject();
            HashSet<ModulesKey> set = new HashSet<ModulesKey>(this.modulesKeys.keySet());
            aStream.writeObject(set);
        }
    }

    private void setModules(ModulesKeyTreeMap<ModulesKey, ModulesKey> keys) {
        this.modulesKeys = keys;
    }

    protected Map<ModulesKey, AbstractModule> getModules() {
        throw new RuntimeException("Deprecated");
    }

    public void changePythonPath(String pythonpath, IProject project, IProgressMonitor monitor) {
        this.pythonPathHelper.setPythonPath(pythonpath);
        ModulesFoundStructure modulesFound = this.pythonPathHelper.getModulesFoundStructure(monitor);
        ModulesKeyTreeMap<ModulesKey, ModulesKey> keys = new ModulesKeyTreeMap<ModulesKey, ModulesKey>();
        int j = 0;
        FastStringBuffer buffer = new FastStringBuffer();
        Iterator<Map.Entry<File, String>> iterator = modulesFound.regularModules.entrySet().iterator();
        while (iterator.hasNext() && !monitor.isCanceled()) {
            Map.Entry<File, String> entry = iterator.next();
            File f = entry.getKey();
            String m = entry.getValue();
            if (j % 15 == 0) {
                buffer.clear();
                monitor.setTaskName(buffer.append("Module resolved: ").append(m).toString());
                monitor.worked(1);
            }
            if (m != null) {
                ModulesKey modulesKey = new ModulesKey(m, f);
                if (!keys.containsKey(modulesKey)) {
                    keys.put(modulesKey, modulesKey);
                } else if (PythonPathHelper.isValidSourceFile(f.getName())) {
                    keys.put(modulesKey, modulesKey);
                }
            }
            ++j;
        }
        for (ModulesFoundStructure.ZipContents zipContents : modulesFound.zipContents) {
            if (monitor.isCanceled()) break;
            for (String filePathInZip : zipContents.foundFileZipPaths) {
                String modName = StringUtils.stripExtension((String)filePathInZip).replace('/', '.');
                ModulesKeyForZip k = new ModulesKeyForZip(modName, zipContents.zipFile, filePathInZip, true);
                keys.put((ModulesKey)k, (ModulesKey)k);
                if (zipContents.zipContentsType != ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_JAR) continue;
                for (String s : new FullRepIterable(FullRepIterable.getWithoutLastPart((String)modName))) {
                    k = new ModulesKeyForZip(s, zipContents.zipFile, s.replace('.', '/'), false);
                    keys.put((ModulesKey)k, (ModulesKey)k);
                }
            }
        }
        this.onChangePythonpath(keys);
        this.setModules(keys);
    }

    protected void onChangePythonpath(SortedMap<ModulesKey, ModulesKey> keys) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemoveSingleModule(ModulesKey key) {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            this.modulesKeys.remove(key);
            cache.remove(key, this);
        }
    }

    protected void removeThem(Collection<ModulesKey> toRem) {
        Iterator<ModulesKey> iter = toRem.iterator();
        while (iter.hasNext()) {
            this.doRemoveSingleModule(iter.next());
        }
    }

    public void removeModules(Collection<ModulesKey> toRem) {
        this.removeThem(toRem);
    }

    public IModule addModule(ModulesKey key) {
        AbstractModule ret = AbstractModule.createEmptyModule(key);
        this.doAddSingleModule(key, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddSingleModule(ModulesKey key, AbstractModule n) {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            this.modulesKeys.put(key, key);
            cache.add(key, n, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllModuleNames(boolean addDependencies, String partStartingWithLowerCase) {
        HashSet<String> s = new HashSet<String>();
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            for (ModulesKey key : this.modulesKeys.keySet()) {
                if (!key.hasPartStartingWith(partStartingWithLowerCase)) continue;
                s.add(key.name);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<ModulesKey, ModulesKey> getAllDirectModulesStartingWith(String strStartingWith) {
        if (strStartingWith.length() == 0) {
            ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
            synchronized (modulesKeyTreeMap) {
                return new ModulesKeyTreeMap<ModulesKey, ModulesKey>((SortedMap<ModulesKey, ModulesKey>)this.modulesKeys);
            }
        }
        ModulesKey startingWith = new ModulesKey(strStartingWith, null);
        ModulesKey endingWith = new ModulesKey(new StringBuffer().append(startingWith).append("z").toString(), null);
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            return new ModulesKeyTreeMap<ModulesKey, ModulesKey>(this.modulesKeys.subMap(startingWith, endingWith));
        }
    }

    public SortedMap<ModulesKey, ModulesKey> getAllModulesStartingWith(String strStartingWith) {
        return this.getAllDirectModulesStartingWith(strStartingWith);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesKey[] getOnlyDirectModules() {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            return this.modulesKeys.keySet().toArray(new ModulesKey[0]);
        }
    }

    public int getSize(boolean addDependenciesSize) {
        return this.modulesKeys.size();
    }

    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        return this.getModule(true, name, nature, dontSearchInit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushTemporaryModule(String moduleName, IModule module) {
        Object object = this.lockTemporaryModules;
        synchronized (object) {
            FastStack stack;
            if (this.temporaryModules == null) {
                this.temporaryModules = new HashMap<String, FastStack<IModule>>();
            }
            if ((stack = this.temporaryModules.get(moduleName)) == null) {
                stack = new FastStack(3);
                this.temporaryModules.put(moduleName, (FastStack<IModule>)stack);
            }
            stack.push((Object)module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popTemporaryModule(String moduleName) {
        Object object = this.lockTemporaryModules;
        synchronized (object) {
            if (this.temporaryModules == null) {
                return;
            }
            FastStack<IModule> stack = this.temporaryModules.get(moduleName);
            if (stack == null) {
                this.temporaryModules = null;
                return;
            }
            try {
                stack.pop();
                if (stack.size() == 0) {
                    this.temporaryModules.remove(moduleName);
                }
                if (this.temporaryModules.size() == 0) {
                    this.temporaryModules = null;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IModule getModule(boolean acceptCompiledModule, String name, IPythonNature nature, boolean dontSearchInit) {
        SourceModule sourceModule;
        SourceModule s;
        if (this.temporaryModules != null) {
            Object object = this.lockTemporaryModules;
            synchronized (object) {
                FastStack<IModule> stack;
                if (this.temporaryModules != null && (stack = this.temporaryModules.get(name)) != null && stack.size() > 0) {
                    return (IModule)stack.peek();
                }
            }
        }
        AbstractModule n = null;
        ModulesKey keyForCacheAccess = new ModulesKey(null, null);
        if (!dontSearchInit) {
            keyForCacheAccess.name = new StringBuffer(name).append(".__init__").toString();
            n = cache.getObj(keyForCacheAccess, this);
            if (n != null) {
                name = new StringBuffer(String.valueOf(name)).append(".__init__").toString();
            }
        }
        if (n == null) {
            keyForCacheAccess.name = name;
            n = cache.getObj(keyForCacheAccess, this);
        }
        if (n instanceof SourceModule && !(s = (SourceModule)n).isSynched()) {
            n = (AbstractModule)this.addModule(this.createModulesKey(s.getName(), s.getFile()));
        }
        if (n instanceof EmptyModule) {
            EmptyModule e = (EmptyModule)n;
            boolean found = false;
            if (!found && e.f != null) {
                if (!e.f.exists()) {
                    keyForCacheAccess.name = name;
                    keyForCacheAccess.file = e.f;
                    this.doRemoveSingleModule(keyForCacheAccess);
                    n = null;
                } else if ((n = this.checkOverride(name, nature, n)) instanceof EmptyModule) {
                    if (e instanceof EmptyModuleForZip) {
                        EmptyModuleForZip emptyModuleForZip = (EmptyModuleForZip)e;
                        if (emptyModuleForZip.pathInZip.endsWith(".class") || !emptyModuleForZip.isFile) {
                            n = JythonModulesManagerUtils.createModuleFromJar(emptyModuleForZip);
                            n = this.decorateModule(n, nature);
                        } else if (FileTypesPreferencesPage.isValidDll(emptyModuleForZip.pathInZip)) {
                            n = new CompiledModule(name, 4, nature.getAstManager());
                            n = this.decorateModule(n, nature);
                        } else if (PythonPathHelper.isValidSourceFile(emptyModuleForZip.pathInZip)) {
                            try {
                                IDocument doc = REF.getDocFromZip((File)emptyModuleForZip.f, (String)emptyModuleForZip.pathInZip);
                                n = AbstractModule.createModuleFromDoc(name, emptyModuleForZip.f, doc, this.getNature(), -1, false);
                                SourceModule zipModule = (SourceModule)n;
                                zipModule.zipFilePath = emptyModuleForZip.pathInZip;
                                n = this.decorateModule(n, nature);
                            }
                            catch (Exception exc1) {
                                PydevPlugin.log(exc1);
                                n = null;
                            }
                        }
                    } else {
                        try {
                            n = AbstractModule.createModule(name, e.f, this.getNature(), -1);
                            n = this.decorateModule(n, nature);
                        }
                        catch (IOException iOException) {
                            keyForCacheAccess.name = name;
                            keyForCacheAccess.file = e.f;
                            this.doRemoveSingleModule(keyForCacheAccess);
                            n = null;
                        }
                        catch (MisconfigurationException exc) {
                            PydevPlugin.log(exc);
                            n = null;
                        }
                    }
                }
            } else if ((n = this.checkOverride(name, nature, n)) instanceof EmptyModule) {
                if (acceptCompiledModule) {
                    n = new CompiledModule(name, 4, nature.getAstManager());
                    n = this.decorateModule(n, nature);
                } else {
                    return null;
                }
            }
            if (n != null) {
                this.doAddSingleModule(this.createModulesKey(name, e.f), n);
            } else {
                System.err.println(new StringBuffer("The module ").append(name).append(" could not be found nor created!").toString());
            }
        }
        if (n instanceof EmptyModule) {
            throw new RuntimeException("Should not be an empty module anymore!");
        }
        if (n instanceof SourceModule && (sourceModule = (SourceModule)n).isBootstrapModule()) {
            n = new CompiledModule(name, 4, nature.getAstManager());
            n = this.decorateModule(n, nature);
        }
        return n;
    }

    private AbstractModule decorateModule(AbstractModule n, IPythonNature nature) {
        if (n instanceof SourceModule && "django.db.models.base".equals(n.getName())) {
            SourceModule sourceModule = (SourceModule)n;
            SimpleNode ast = sourceModule.getAst();
            stmtType[] stmtTypeArray = ((Module)ast).body;
            int n2 = ((Module)ast).body.length;
            int n3 = 0;
            while (n3 < n2) {
                stmtType node = stmtTypeArray[n3];
                if (node instanceof ClassDef && "Model".equals(NodeUtils.getRepresentationString((SimpleNode)node))) {
                    Object[][] metaclassAttrs = new Object[][]{{"objects", NodeUtils.makeAttribute((String)"django.db.models.manager.Manager()")}, {"DoesNotExist", new Name("Exception", 1, false)}, {"MultipleObjectsReturned", new Name("Exception", 1, false)}};
                    ClassDef classDef = (ClassDef)node;
                    stmtType[] newBody = new stmtType[classDef.body.length + metaclassAttrs.length];
                    System.arraycopy(classDef.body, 0, newBody, metaclassAttrs.length, classDef.body.length);
                    int i = 0;
                    Object[][] objectArrayArray = metaclassAttrs;
                    int n4 = metaclassAttrs.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Object[] objAndType = objectArrayArray[n5];
                        Name name = new Name((String)objAndType[0], 2, false);
                        name.beginColumn = classDef.beginColumn + 4;
                        name.beginLine = classDef.beginLine + 1;
                        newBody[i] = new Assign(new exprType[]{name}, (exprType)objAndType[1]);
                        newBody[i].beginColumn = classDef.beginColumn + 4;
                        newBody[i].beginLine = classDef.beginLine + 1;
                        ++i;
                        ++n5;
                    }
                    classDef.body = newBody;
                    break;
                }
                ++n3;
            }
        }
        return n;
    }

    private AbstractModule checkOverride(String name, IPythonNature nature, AbstractModule emptyModule) {
        return emptyModule;
    }

    private ModulesKey createModulesKey(String name, File f) {
        ModulesKey newEntry = new ModulesKey(name, f);
        ModulesKeyTreeMap.Entry<ModulesKey, ModulesKey> oldEntry = this.modulesKeys.getEntry(newEntry);
        if (oldEntry != null) {
            return oldEntry.getKey();
        }
        return newEntry;
    }

    public void clearCache() {
        ModulesManager.cache.internalCache.clear();
    }

    public boolean isInPythonPath(IResource member, IProject container) {
        return this.resolveModule(member, container) != null;
    }

    public String resolveModule(IResource member, IProject container) {
        File inOs = member.getRawLocation().toFile();
        return this.resolveModule(REF.getFileAbsolutePath((File)inOs));
    }

    protected String getResolveModuleErr(IResource member) {
        return new StringBuffer("Unable to find the path ").append(member).append(" in the project were it\n").append("is added as a source folder for pydev.").append(this.getClass()).toString();
    }

    public String resolveModule(String full) {
        return this.pythonPathHelper.resolveModule(full, false);
    }

    public List<String> getPythonPath() {
        if (this.pythonPathHelper == null) {
            return new ArrayList<String>();
        }
        return this.pythonPathHelper.getPythonpath();
    }

    public /* synthetic */ Object getPythonPathHelper() {
        return this.getPythonPathHelper();
    }

    protected static class CompletionCache {
        public IModulesManager[] referencedManagers;
        public IModulesManager[] referredManagers;

        protected CompletionCache() {
        }

        public IModulesManager[] getManagers(boolean referenced) {
            if (referenced) {
                return this.referencedManagers;
            }
            return this.referredManagers;
        }

        public void setManagers(IModulesManager[] ret, boolean referenced) {
            if (referenced) {
                this.referencedManagers = ret;
            } else {
                this.referredManagers = ret;
            }
        }
    }
}

