/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.navigator.InterpreterInfoTreeNode;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.PythonpathTreeNode;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInfoToTreeStructure {
    public static InterpreterInfoTreeNode<LabelAndImage> createFrom(IInterpreterInfo interpreterInfo) {
        InterpreterInfoTreeNode<LabelAndImage> root;
        ImageCache imageCache = PydevPlugin.getImageCache();
        if (interpreterInfo != null) {
            root = new InterpreterInfoTreeNode<LabelAndImage>(null, new LabelAndImage(interpreterInfo.getNameForUI(), imageCache.get("icons/python_16x16.png")));
            String executableOrJar = interpreterInfo.getExecutableOrJar();
            File file = new File(executableOrJar);
            if (file.exists()) {
                new PythonpathTreeNode(root, file.getParentFile(), imageCache.get("icons/python_16x16.png"), true);
            }
            InterpreterInfoTreeNode<LabelAndImage> systemLibs = new InterpreterInfoTreeNode<LabelAndImage>(root, new LabelAndImage("System Libs", imageCache.get("icons/library_obj.gif")));
            List pythonPath = interpreterInfo.getPythonPath();
            for (String string : pythonPath) {
                new PythonpathTreeNode(systemLibs, new File(string), imageCache.get("icons/jar_l_obj.gif"), true);
            }
            InterpreterInfoTreeNode<LabelAndImage> predefinedCompletions = new InterpreterInfoTreeNode<LabelAndImage>(root, new LabelAndImage("Predefined Completions", imageCache.get("icons/library_obj.gif")));
            for (String string : interpreterInfo.getPredefinedCompletionsPath()) {
                new PythonpathTreeNode(predefinedCompletions, new File(string), imageCache.get("icons/jar_l_obj.gif"), true);
            }
            InterpreterInfoTreeNode<LabelAndImage> forcedBuiltins = new InterpreterInfoTreeNode<LabelAndImage>(root, new LabelAndImage("Forced builtins", imageCache.get("icons/library_obj.gif")));
            Iterator it = interpreterInfo.forcedLibsIterator();
            while (it.hasNext()) {
                String string = (String)it.next();
                new InterpreterInfoTreeNode<LabelAndImage>(forcedBuiltins, new LabelAndImage(string, imageCache.get("icons/jar_obj.gif")));
            }
        } else {
            root = new InterpreterInfoTreeNode<LabelAndImage>(null, new LabelAndImage("No Interpreter Configured", imageCache.get("icons/python_16x16.png")));
        }
        return root;
    }
}

