/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PropertiesHelper;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringSubstitution;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.IPythonPathContributor;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonPathNature
implements IPythonPathNature {
    private volatile IProject fProject;
    private volatile PythonNature fNature;
    private static QualifiedName projectSourcePathQualifiedName = null;
    private static QualifiedName projectExternalSourcePathQualifiedName = null;
    private static QualifiedName projectVariableSubstitutionQualifiedName = null;
    private boolean waited = false;

    static QualifiedName getProjectSourcePathQualifiedName() {
        if (projectSourcePathQualifiedName == null) {
            projectSourcePathQualifiedName = new QualifiedName(PydevPlugin.getPluginID(), "PROJECT_SOURCE_PATH");
        }
        return projectSourcePathQualifiedName;
    }

    static QualifiedName getProjectExternalSourcePathQualifiedName() {
        if (projectExternalSourcePathQualifiedName == null) {
            projectExternalSourcePathQualifiedName = new QualifiedName(PydevPlugin.getPluginID(), "PROJECT_EXTERNAL_SOURCE_PATH");
        }
        return projectExternalSourcePathQualifiedName;
    }

    static QualifiedName getProjectVariableSubstitutionQualifiedName() {
        if (projectVariableSubstitutionQualifiedName == null) {
            projectVariableSubstitutionQualifiedName = new QualifiedName(PydevPlugin.getPluginID(), "PROJECT_VARIABLE_SUBSTITUTION");
        }
        return projectVariableSubstitutionQualifiedName;
    }

    public void setProject(IProject project, IPythonNature nature) {
        this.fProject = project;
        this.fNature = (PythonNature)nature;
    }

    public IPythonNature getNature() {
        return this.fNature;
    }

    public List<String> getCompleteProjectPythonPath(IInterpreterInfo interpreter, IInterpreterManager manager) {
        IModulesManager projectModulesManager = this.getProjectModulesManager();
        if (projectModulesManager == null && !this.waited) {
            this.waited = true;
            int i = 0;
            while (i < 10 && projectModulesManager == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                projectModulesManager = this.getProjectModulesManager();
                ++i;
            }
        }
        if (projectModulesManager == null) {
            return null;
        }
        return projectModulesManager.getCompletePythonPath(interpreter, manager);
    }

    private IModulesManager getProjectModulesManager() {
        PythonNature nature = this.fNature;
        if (nature == null) {
            return null;
        }
        ICodeCompletionASTManager astManager = nature.getAstManager();
        if (astManager == null) {
            return null;
        }
        return astManager.getModulesManager();
    }

    public String getOnlyProjectPythonPathStr(boolean addExternal) throws CoreException {
        String source = null;
        String external = null;
        String contributed = null;
        IProject project = this.fProject;
        PythonNature nature = this.fNature;
        if (project == null || nature == null) {
            return "";
        }
        StringSubstitution stringSubstitution = new StringSubstitution((IPythonNature)nature);
        source = this.getProjectSourcePath(true);
        if (addExternal) {
            external = this.getProjectExternalSourcePath(true);
        }
        contributed = stringSubstitution.performPythonpathStringSubstitution(this.getContributedSourcePath(project));
        if (source == null) {
            source = "";
        }
        List strings = StringUtils.splitAndRemoveEmptyTrimmed((String)source, (char)'|');
        FastStringBuffer buf = new FastStringBuffer();
        IWorkspaceRoot root = null;
        boolean checkedFullSynch = false;
        HashSet<String> directMembersChecked = new HashSet<String>();
        ResourcesPlugin resourcesPlugin = ResourcesPlugin.getPlugin();
        for (String currentPath : strings) {
            if (currentPath.trim().length() <= 0) continue;
            Path p = new Path(currentPath);
            if (resourcesPlugin == null) {
                buf.append(currentPath);
                buf.append("|");
                continue;
            }
            if (root == null) {
                root = ResourcesPlugin.getWorkspace().getRoot();
            }
            if (p.segmentCount() < 1) {
                Log.log((String)new StringBuffer("Found no segment in: ").append(currentPath).append(" for: ").append(project).toString());
                continue;
            }
            IContainer container = null;
            Object r = null;
            try {
                r = root.findMember((IPath)p);
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
            if (!(r instanceof IContainer) && !(r instanceof IFile)) {
                String firstSegment = p.segment(0);
                IResource firstSegmentResource = root.findMember(firstSegment);
                if (!(firstSegmentResource instanceof IContainer) && !(firstSegmentResource instanceof IFile)) {
                    if (!checkedFullSynch) {
                        checkedFullSynch = true;
                        try {
                            root.refreshLocal(2, null);
                        }
                        catch (CoreException coreException) {}
                    }
                } else if (!directMembersChecked.contains(firstSegment)) {
                    directMembersChecked.add(firstSegment);
                    try {
                        firstSegmentResource.refreshLocal(2, null);
                    }
                    catch (CoreException coreException) {}
                }
                try {
                    r = root.findMember((IPath)p);
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            }
            if (r instanceof IContainer) {
                container = (IContainer)r;
                buf.append(REF.getFileAbsolutePath((File)container.getLocation().toFile()));
                buf.append("|");
                continue;
            }
            if (r instanceof IFile) {
                String extension = r.getFileExtension();
                if (extension == null || !FileTypesPreferencesPage.isValidZipFile(new StringBuffer(".").append(extension).toString())) {
                    PydevPlugin.log(new StringBuffer("Error: the path ").append(currentPath).append(" is a file but is not a recognized zip file.").toString());
                    continue;
                }
                buf.append(REF.getFileAbsolutePath((File)r.getLocation().toFile()));
                buf.append("|");
                continue;
            }
            Log.log((int)2, (String)new StringBuffer("Unable to find the path ").append(currentPath).append(" in the project were it's \n").append("added as a source folder for pydev (project: ").append(project.getName()).append(") member:").append(r).toString(), null);
            String curr = currentPath;
            Path path = new Path(curr.trim());
            if (project.getFullPath().isPrefixOf((IPath)path)) {
                path = path.removeFirstSegments(1);
                r = FileTypesPreferencesPage.isValidZipFile(curr) ? project.getFile((IPath)path) : project.getFolder((IPath)path);
                if (r != null) {
                    buf.append(REF.getFileAbsolutePath((File)r.getLocation().toFile()));
                    buf.append("|");
                    continue;
                }
            }
            IPath rootLocation = root.getRawLocation();
            buf.append(REF.getFileAbsolutePath((File)rootLocation.append(currentPath.trim()).toFile()));
            buf.append("|");
        }
        if (external == null) {
            external = "";
        }
        return buf.append("|").append(external).append("|").append(contributed).toString();
    }

    private String getContributedSourcePath(IProject project) throws CoreException {
        FastStringBuffer buff = new FastStringBuffer();
        List contributors = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_pythonpath_contrib");
        for (IPythonPathContributor contributor : contributors) {
            String additionalPythonPath = contributor.getAdditionalPythonPath(project);
            if (additionalPythonPath == null || additionalPythonPath.trim().length() <= 0) continue;
            if (buff.length() > 0) {
                buff.append("|");
            }
            buff.append(additionalPythonPath.trim());
        }
        return buff.toString();
    }

    public void setProjectSourcePath(String newSourcePath) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature != null) {
            nature.getStore().setPathProperty(PythonPathNature.getProjectSourcePathQualifiedName(), newSourcePath);
        }
    }

    public void setProjectExternalSourcePath(String newExternalSourcePath) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature != null) {
            nature.getStore().setPathProperty(PythonPathNature.getProjectExternalSourcePathQualifiedName(), newExternalSourcePath);
        }
    }

    public void setVariableSubstitution(Map<String, String> variableSubstitution) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature != null) {
            nature.getStore().setMapProperty(PythonPathNature.getProjectVariableSubstitutionQualifiedName(), variableSubstitution);
        }
    }

    public void clearCaches() {
    }

    public Set<String> getProjectSourcePathSet(boolean replace) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature == null) {
            return new HashSet<String>();
        }
        String projectSourcePath = this.getProjectSourcePath(replace);
        return new HashSet<String>(StringUtils.splitAndRemoveEmptyTrimmed((String)projectSourcePath, (char)'|'));
    }

    public String getProjectSourcePath(boolean replace) throws CoreException {
        boolean restore = false;
        IProject project = this.fProject;
        PythonNature nature = this.fNature;
        if (project == null || nature == null) {
            return "";
        }
        String projectSourcePath = nature.getStore().getPathProperty(PythonPathNature.getProjectSourcePathQualifiedName());
        if (projectSourcePath == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        List paths = StringUtils.splitAndRemoveEmptyTrimmed((String)projectSourcePath, (char)'|');
        IPath projectPath = project.getFullPath();
        for (String path : paths) {
            if (path.trim().length() <= 0) continue;
            if (path.indexOf("${") != -1) {
                buffer.append(path);
            } else {
                Path p = new Path(path);
                if (p.isEmpty()) continue;
                if (projectPath != null && !projectPath.isPrefixOf((IPath)p)) {
                    p = p.removeFirstSegments(1);
                    p = projectPath.append((IPath)p);
                    restore = true;
                }
                buffer.append(p.toString());
            }
            buffer.append("|");
        }
        if (restore) {
            projectSourcePath = buffer.toString();
            this.setProjectSourcePath(projectSourcePath);
            nature.rebuildPath();
        }
        return this.trimAndReplaceVariablesIfNeeded(replace, projectSourcePath, nature);
    }

    private String trimAndReplaceVariablesIfNeeded(boolean replace, String projectSourcePath, PythonNature nature) throws CoreException {
        String ret = StringUtils.leftAndRightTrim((String)projectSourcePath, (char)'|');
        if (replace) {
            StringSubstitution substitution = new StringSubstitution((IPythonNature)nature);
            ret = substitution.performPythonpathStringSubstitution(ret);
        }
        return ret;
    }

    public String getProjectExternalSourcePath(boolean replace) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature == null) {
            return "";
        }
        String extPath = nature.getStore().getPathProperty(PythonPathNature.getProjectExternalSourcePathQualifiedName());
        if (extPath == null) {
            extPath = "";
        }
        return this.trimAndReplaceVariablesIfNeeded(replace, extPath, nature);
    }

    public Map<String, String> getVariableSubstitution() throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        return this.getVariableSubstitution(true);
    }

    public Map<String, String> getVariableSubstitution(boolean addInterpreterInfoSubstitutions) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        IInterpreterInfo info;
        Properties stringSubstitutionVariables;
        PythonNature nature = this.fNature;
        if (nature == null) {
            return new HashMap<String, String>();
        }
        Map<Object, Object> variableSubstitution = addInterpreterInfoSubstitutions ? ((stringSubstitutionVariables = (info = nature.getProjectInterpreter()).getStringSubstitutionVariables()) == null ? new HashMap() : PropertiesHelper.createMapFromProperties((Properties)stringSubstitutionVariables)) : new HashMap();
        Map<String, String> variableSubstitution2 = nature.getStore().getMapProperty(PythonPathNature.getProjectVariableSubstitutionQualifiedName());
        if (variableSubstitution2 != null) {
            if (variableSubstitution != null) {
                variableSubstitution.putAll(variableSubstitution2);
            } else {
                variableSubstitution = variableSubstitution2;
            }
        }
        if (variableSubstitution == null) {
            variableSubstitution = new HashMap();
        }
        return variableSubstitution;
    }
}

