/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.debug.newconsole.prefs.ColorManager;
import org.python.pydev.plugin.PydevPlugin;

public class PydevDebugPlugin
extends AbstractUIPlugin {
    private static PydevDebugPlugin plugin;
    public ImageCache imageCache;
    private List<ILaunch> consoleLaunches = new ArrayList<ILaunch>();

    public PydevDebugPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.imageCache = new ImageCache(PydevDebugPlugin.getDefault().getBundle().getEntry("/"));
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ColorManager.getDefault().dispose();
        this.imageCache.dispose();
        Iterator<ILaunch> iterator = new ArrayList<ILaunch>(this.consoleLaunches).iterator();
        while (iterator.hasNext()) {
            ILaunch l = iterator.next();
            try {
                this.removeConsoleLaunch(l);
            }
            catch (Exception e) {
                PydevPlugin.log((Throwable)e);
            }
        }
    }

    public static PydevDebugPlugin getDefault() {
        return plugin;
    }

    public static String getPluginID() {
        PydevDebugPlugin d = PydevDebugPlugin.getDefault();
        if (d == null) {
            return "Unable to get id";
        }
        return d.getBundle().getSymbolicName();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static ImageCache getImageCache() {
        return PydevDebugPlugin.plugin.imageCache;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PydevDebugPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Status makeStatus(int errorLevel, String message, Throwable e) {
        return new Status(errorLevel, PydevDebugPlugin.getPluginID(), errorLevel, message, e);
    }

    public static void log(int errorLevel, String message, Throwable e) {
        Status s = PydevDebugPlugin.makeStatus(errorLevel, message, e);
        PydevDebugPlugin.getDefault().getLog().log((IStatus)s);
    }

    public static void errorDialog(final String message, final Throwable t) {
        Display disp = Display.getDefault();
        disp.asyncExec(new Runnable(){

            public void run() {
                Shell shell;
                IWorkbenchWindow window = PydevDebugPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                Shell shell2 = shell = window == null ? null : window.getShell();
                if (shell != null) {
                    Status status = PydevDebugPlugin.makeStatus(4, "Error logged from Pydev Debug: ", t);
                    ErrorDialog.openError((Shell)shell, (String)"Its an error", (String)message, (IStatus)status);
                }
            }
        });
        PydevDebugPlugin.log(4, message, t);
    }

    public static File getScriptWithinPySrc(String targetExec) throws CoreException {
        IPath relative = new Path("pysrc").addTrailingSeparator().append(targetExec);
        Bundle bundle = PydevDebugPlugin.getDefault().getBundle();
        URL bundleURL = Platform.find((Bundle)bundle, (IPath)relative);
        try {
            URL fileURL = Platform.asLocalURL((URL)bundleURL);
            File f = new File(fileURL.getPath());
            return f;
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Can't find python debug script", null));
        }
    }

    public static File getPySrcPath() throws CoreException {
        Path relative = new Path("pysrc");
        Bundle bundle = PydevDebugPlugin.getDefault().getBundle();
        URL bundleURL = Platform.find((Bundle)bundle, (IPath)relative);
        try {
            URL fileURL = Platform.asLocalURL((URL)bundleURL);
            File f = new File(fileURL.getPath());
            return f;
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Can't find python debug script", null));
        }
    }

    public void addConsoleLaunch(ILaunch launch) {
        this.consoleLaunches.add(launch);
    }

    public void removeConsoleLaunch(ILaunch launch) {
        IProcess[] processes;
        if (this.consoleLaunches.remove(launch) && (processes = launch.getProcesses()) != null) {
            IProcess[] iProcessArray = processes;
            int n = processes.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess p = iProcessArray[n2];
                try {
                    p.terminate();
                }
                catch (Exception e) {
                    PydevPlugin.log((Throwable)e);
                }
                ++n2;
            }
        }
    }
}

