/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.MainModuleTab;
import org.python.pydev.debug.ui.blocks.ProgramArgumentsBlock;
import org.python.pydev.debug.ui.blocks.VMArgumentsBlock;
import org.python.pydev.debug.ui.blocks.WorkingDirectoryBlock;

public class ArgumentsTab
extends AbstractLaunchConfigurationTab {
    private WorkingDirectoryBlock workingDirectoryBlock;
    private VMArgumentsBlock vmArgumentsBlock;
    private ProgramArgumentsBlock programArgumentsBlock = new ProgramArgumentsBlock();

    public ArgumentsTab(MainModuleTab mainModuleTab) {
        this.vmArgumentsBlock = new VMArgumentsBlock();
        this.workingDirectoryBlock = new WorkingDirectoryBlock(mainModuleTab);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout gridLayout = new GridLayout();
        comp.setLayout((Layout)gridLayout);
        this.programArgumentsBlock.createControl(comp);
        this.vmArgumentsBlock.createControl(comp);
        this.workingDirectoryBlock.createControl(comp);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.programArgumentsBlock.isValid(launchConfig)) {
            return false;
        }
        if (!this.vmArgumentsBlock.isValid(launchConfig)) {
            return false;
        }
        return this.workingDirectoryBlock.isValid(launchConfig);
    }

    public String getName() {
        return "Arguments";
    }

    public Image getImage() {
        return PydevDebugPlugin.getImageCache().get("icons/arguments.gif");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy arg0) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.programArgumentsBlock.initializeFrom(configuration);
        this.vmArgumentsBlock.initializeFrom(configuration);
        this.workingDirectoryBlock.initializeFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.programArgumentsBlock.performApply(configuration);
        this.vmArgumentsBlock.performApply(configuration);
        this.workingDirectoryBlock.performApply(configuration);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.programArgumentsBlock.setLaunchConfigurationDialog(dialog);
        this.workingDirectoryBlock.setLaunchConfigurationDialog(dialog);
        this.vmArgumentsBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String result = super.getErrorMessage();
        if (result == null) {
            result = this.programArgumentsBlock.getErrorMessage();
        }
        if (result == null) {
            result = this.workingDirectoryBlock.getErrorMessage();
        }
        if (result == null) {
            result = this.vmArgumentsBlock.getErrorMessage();
        }
        return result;
    }

    public String getMessage() {
        String result = super.getMessage();
        if (result == null) {
            result = this.programArgumentsBlock.getMessage();
        }
        if (result == null) {
            result = this.workingDirectoryBlock.getMessage();
        }
        if (result == null) {
            result = this.vmArgumentsBlock.getMessage();
        }
        return result;
    }
}

