/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.hover;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.debug.ui.actions.EvalExpressionAction;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.hover.IPyHoverParticipant;
import org.python.pydev.editor.hover.PyHoverPreferencesPage;
import org.python.pydev.plugin.PydevPlugin;

public class PyDebugHover
implements IPyHoverParticipant {
    public String getHoverText(IRegion hoverRegion, PySourceViewer s, PySelection ps, ITextSelection selection) {
        block14: {
            if (!PyHoverPreferencesPage.getShowValuesWhileDebuggingOnHover()) {
                return null;
            }
            IAdaptable object = DebugUITools.getDebugContext();
            IDebugElement context = null;
            if (object instanceof IDebugElement) {
                context = (IDebugElement)object;
            } else if (object instanceof ILaunch) {
                context = ((ILaunch)object).getDebugTarget();
            }
            if (context != null) {
                IDebugTarget debugTarget = context.getDebugTarget();
                if (debugTarget == null || debugTarget.isTerminated()) {
                    return null;
                }
                String act = null;
                ITextSelection textSelection = selection;
                int mouseOffset = ps.getAbsoluteCursorOffset();
                int offset = textSelection.getOffset();
                int len = textSelection.getLength();
                boolean reportSyntaxErrors = false;
                if (len > 0 && mouseOffset >= offset && offset + len >= mouseOffset) {
                    try {
                        act = ps.getDoc().get(offset, len);
                        reportSyntaxErrors = true;
                    }
                    catch (BadLocationException e) {
                        PydevPlugin.log((Throwable)e);
                    }
                }
                if (act == null || act.trim().length() == 0) {
                    String[] activationTokenAndQual = ps.getActivationTokenAndQual(true);
                    act = String.valueOf(activationTokenAndQual[0]) + activationTokenAndQual[1];
                }
                IWatchExpression watchExpression = EvalExpressionAction.createWatchExpression(act);
                watchExpression.evaluate();
                EvalExpressionAction.waitForExpressionEvaluation(watchExpression);
                IValue value = watchExpression.getValue();
                if (value != null) {
                    String valueString;
                    block15: {
                        valueString = value.getValueString();
                        if (valueString == null) break block14;
                        if (reportSyntaxErrors || !valueString.startsWith("SyntaxError") || valueString.indexOf("<string>") == -1) break block15;
                        return null;
                    }
                    try {
                        return String.valueOf(valueString) + "\n";
                    }
                    catch (DebugException e) {
                        PydevPlugin.log((Throwable)e);
                    }
                }
            }
        }
        return null;
    }
}

