/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;

public class PUtil {
    public static Iterator NULL_ITERATOR = Collections.EMPTY_LIST.iterator();
    public static Enumeration NULL_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    public static long DEFAULT_ACTIVITY_STEP_RATE = 20L;
    public static int ACTIVITY_SCHEDULER_FRAME_DELAY = 10;
    public static OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int off, int len) {
        }

        public void write(int b) {
        }
    };
    private static final int PATH_IS_DONE = -1;

    public static PCamera createBasicScenegraph() {
        PRoot r = new PRoot();
        PLayer l = new PLayer();
        PCamera c = new PCamera();
        r.addChild(c);
        r.addChild(l);
        c.addLayer(l);
        return c;
    }

    public static void writeStroke(Stroke aStroke, ObjectOutputStream out) throws IOException {
        if (aStroke instanceof Serializable) {
            out.writeBoolean(true);
            out.writeBoolean(true);
            out.writeObject(aStroke);
        } else if (aStroke instanceof BasicStroke) {
            out.writeBoolean(true);
            out.writeBoolean(false);
            BasicStroke s = (BasicStroke)aStroke;
            float[] dash = s.getDashArray();
            if (dash == null) {
                out.write(0);
            } else {
                out.write(dash.length);
                int i = 0;
                while (i < dash.length) {
                    out.writeFloat(dash[i]);
                    ++i;
                }
            }
            out.writeFloat(s.getLineWidth());
            out.writeInt(s.getEndCap());
            out.writeInt(s.getLineJoin());
            out.writeFloat(s.getMiterLimit());
            out.writeFloat(s.getDashPhase());
        } else {
            out.writeBoolean(false);
        }
    }

    public static Stroke readStroke(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean wroteStroke = in.readBoolean();
        if (wroteStroke) {
            boolean serializedStroke = in.readBoolean();
            if (serializedStroke) {
                return (Stroke)in.readObject();
            }
            float[] dash = null;
            int dashLength = in.read();
            if (dashLength != 0) {
                dash = new float[dashLength];
                int i = 0;
                while (i < dashLength) {
                    dash[i] = in.readFloat();
                    ++i;
                }
            }
            float lineWidth = in.readFloat();
            int endCap = in.readInt();
            int lineJoin = in.readInt();
            float miterLimit = in.readFloat();
            float dashPhase = in.readFloat();
            return new BasicStroke(lineWidth, endCap, lineJoin, miterLimit, dash, dashPhase);
        }
        return null;
    }

    public static GeneralPath readPath(ObjectInputStream in) throws IOException, ClassNotFoundException {
        GeneralPath path = new GeneralPath();
        block8: while (true) {
            int segType = in.readInt();
            switch (segType) {
                case 0: {
                    path.moveTo(in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 1: {
                    path.lineTo(in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 2: {
                    path.quadTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 3: {
                    path.curveTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 4: {
                    path.closePath();
                    continue block8;
                }
                case -1: {
                    return path;
                }
            }
            break;
        }
        throw new IOException();
    }

    public static void writePath(GeneralPath path, ObjectOutputStream out) throws IOException {
        PathIterator i = path.getPathIterator(null);
        float[] data = new float[6];
        while (!i.isDone()) {
            switch (i.currentSegment(data)) {
                case 0: {
                    out.writeInt(0);
                    out.writeFloat(data[0]);
                    out.writeFloat(data[1]);
                    break;
                }
                case 1: {
                    out.writeInt(1);
                    out.writeFloat(data[0]);
                    out.writeFloat(data[1]);
                    break;
                }
                case 2: {
                    out.writeInt(2);
                    out.writeFloat(data[0]);
                    out.writeFloat(data[1]);
                    out.writeFloat(data[2]);
                    out.writeFloat(data[3]);
                    break;
                }
                case 3: {
                    out.writeInt(3);
                    out.writeFloat(data[0]);
                    out.writeFloat(data[1]);
                    out.writeFloat(data[2]);
                    out.writeFloat(data[3]);
                    out.writeFloat(data[4]);
                    out.writeFloat(data[5]);
                    break;
                }
                case 4: {
                    out.writeInt(4);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            i.next();
        }
        out.writeInt(-1);
    }
}

