/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.fastparser;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.core.ObjectsPool;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;

public final class FastDefinitionsParser {
    private final char[] cs;
    private final int length;
    private int currIndex = 0;
    private int col;
    private int row = 0;
    private int firstCharCol = 1;
    private final ArrayList<stmtType> body = new ArrayList();
    private final FastStack<ClassDef> stack = new FastStack();
    private final FastStack<List<stmtType>> stackBody = new FastStack();
    private final FastStringBuffer lineBuffer = new FastStringBuffer();
    private static final boolean DEBUG = false;
    private final ObjectsPool.ObjectsPoolMap interned = new ObjectsPool.ObjectsPoolMap();
    public static List<ICallback<Object, Tuple<String, SimpleNode>>> parseCallbacks = new ArrayList<ICallback<Object, Tuple<String, SimpleNode>>>();

    private FastDefinitionsParser(char[] cs) {
        this.cs = cs;
        this.length = cs.length;
    }

    private void extractBody() throws SyntaxErrorException {
        ParsingUtils parsingUtils = ParsingUtils.create((Object)this.cs);
        if (this.currIndex < this.length) {
            this.handleNewLine(parsingUtils);
        }
        if (this.currIndex < 0) {
            this.currIndex = 0;
        }
        while (this.currIndex < this.length) {
            char c = this.cs[this.currIndex];
            block0 : switch (c) {
                case '\"': 
                case '\'': {
                    int initialIndex = this.currIndex;
                    this.currIndex = parsingUtils.getLiteralEnd(this.currIndex, c);
                    this.updateCountRow(initialIndex, this.currIndex);
                    break;
                }
                case '#': {
                    while (this.currIndex < this.length) {
                        c = this.cs[this.currIndex];
                        if (c == '\r' || c == '\n') {
                            --this.currIndex;
                            break block0;
                        }
                        ++this.currIndex;
                    }
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    int initialIndex = this.currIndex;
                    this.currIndex = parsingUtils.eatPar(this.currIndex, null, c);
                    this.updateCountRow(initialIndex, this.currIndex);
                    break;
                }
                case '\r': {
                    if (this.currIndex < this.length - 1 && this.cs[this.currIndex + 1] == '\n') {
                        ++this.currIndex;
                    }
                }
                case '\n': {
                    ++this.currIndex;
                    this.handleNewLine(parsingUtils);
                    if (this.currIndex >= this.length) break;
                    c = this.cs[this.currIndex];
                    break;
                }
                case '=': {
                    if (this.currIndex >= this.length - 1 || this.cs[this.currIndex + 1] == '=') break;
                    int initialIndex = this.currIndex;
                    this.currIndex = parsingUtils.getFullFlattenedLine(this.currIndex, this.lineBuffer);
                    this.updateCountRow(initialIndex, this.currIndex);
                    String equalsLine = this.lineBuffer.toString().trim();
                    this.lineBuffer.clear();
                    List splitted = StringUtils.split((String)equalsLine, (char)'=');
                    int splittedLen = splitted.size();
                    ArrayList<exprType> targets = new ArrayList<exprType>();
                    int j = 0;
                    while (j < splittedLen - 1 || splittedLen == 1 && j == 0) {
                        String lineContents = ((String)splitted.get(j)).trim();
                        if (lineContents.length() != 0) {
                            boolean add = true;
                            int i = 0;
                            while (i < lineContents.length()) {
                                char lineC = lineContents.charAt(i);
                                if (lineC != '.' && !Character.isJavaIdentifierPart(lineC)) {
                                    add = false;
                                    break;
                                }
                                ++i;
                            }
                            if (add) {
                                if (lineContents.indexOf(46) != -1) {
                                    List dotSplit = StringUtils.dotSplit((String)lineContents);
                                    if (dotSplit.size() == 2 && ((String)dotSplit.get(0)).equals("self")) {
                                        Attribute attribute = new Attribute(new Name("self", 1, false), new NameTok((String)dotSplit.get(1), 8), 1);
                                        targets.add(attribute);
                                    }
                                } else {
                                    Name name = new Name(lineContents, 2, false);
                                    targets.add(name);
                                }
                            }
                        }
                        ++j;
                    }
                    if (targets.size() <= 0) break;
                    Assign assign = new Assign(targets.toArray(new exprType[targets.size()]), null);
                    assign.beginColumn = this.firstCharCol;
                    assign.beginLine = this.row;
                    this.addToPertinentScope(assign);
                }
            }
            this.lineBuffer.append(c);
            ++this.currIndex;
            ++this.col;
        }
        while (this.stack.size() > 0) {
            this.endScope();
        }
    }

    public void updateCountRow(int initialIndex, int currIndex) {
        int len = this.cs.length;
        int k = initialIndex;
        while (k < len && k <= currIndex) {
            char c = this.cs[k];
            switch (c) {
                case '\n': {
                    ++this.row;
                    break;
                }
                case '\r': {
                    ++this.row;
                    if (k >= len - 1 || k > currIndex - 1 || this.cs[k + 1] != '\n') break;
                    ++k;
                }
            }
            ++k;
        }
    }

    private void handleNewLine(ParsingUtils parsingUtils) throws SyntaxErrorException {
        if (this.currIndex >= this.length - 1) {
            return;
        }
        this.col = 1;
        ++this.row;
        this.lineBuffer.clear();
        char c = this.cs[this.currIndex];
        while (this.currIndex < this.length - 1 && Character.isWhitespace(c) && c != '\r' && c != '\n') {
            ++this.currIndex;
            ++this.col;
            c = this.cs[this.currIndex];
        }
        if (c == 'c' && this.matchClass()) {
            int startClassCol = this.col;
            this.currIndex += 6;
            this.col += 6;
            this.startClass(this.getNextIdentifier(c), this.row, startClassCol);
        } else if (c == 'd' && this.matchFunction()) {
            int startMethodCol = this.col;
            this.currIndex += 4;
            this.col += 4;
            this.startMethod(this.getNextIdentifier(c), this.row, startMethodCol);
        }
        this.firstCharCol = this.col;
        if (this.currIndex < this.length) {
            int initialIndex = this.currIndex;
            int tempIndex = this.skipWhitespaces(this.currIndex);
            if (tempIndex >= this.length) {
                return;
            }
            c = this.cs[tempIndex];
            boolean updateIndex = false;
            switch (c) {
                case '(': {
                    tempIndex = parsingUtils.eatPar(tempIndex, null, c);
                    if (tempIndex < this.length && (c = this.cs[tempIndex = this.skipWhitespaces(tempIndex)]) == ')') {
                        ++tempIndex;
                    }
                    if (tempIndex < this.length && (c = this.cs[tempIndex = this.skipWhitespaces(tempIndex)]) == ':' && ++tempIndex < this.length && (c = this.cs[tempIndex]) != '\r' && c != '\n') {
                        updateIndex = true;
                    }
                    if (updateIndex) {
                        this.currIndex = tempIndex = this.skipWhitespaces(tempIndex);
                        this.updateCountRow(initialIndex, this.currIndex);
                        int i = tempIndex;
                        while (i > 0 && i < this.length) {
                            c = this.cs[i];
                            if (c == '\r' || c == '\n') break;
                            --i;
                        }
                        this.firstCharCol = tempIndex - i;
                        break;
                    }
                    --this.currIndex;
                    break;
                }
                default: {
                    --this.currIndex;
                }
            }
        }
    }

    private int skipWhitespaces(int tempIndex) {
        while (tempIndex < this.length) {
            char c = this.cs[tempIndex];
            if (c != ' ' && c != '\t') break;
            ++tempIndex;
        }
        return tempIndex;
    }

    private String getNextIdentifier(char c) {
        c = this.cs[this.currIndex];
        while (this.currIndex < this.length && Character.isWhitespace(c)) {
            ++this.currIndex;
            c = this.cs[this.currIndex];
        }
        int currClassNameCol = this.currIndex;
        while (Character.isJavaIdentifierPart(c)) {
            ++this.currIndex;
            if (this.currIndex >= this.length) break;
            c = this.cs[this.currIndex];
        }
        return ObjectsPool.internLocal((ObjectsPool.ObjectsPoolMap)this.interned, (String)new String(this.cs, currClassNameCol, this.currIndex - currClassNameCol));
    }

    private void startMethod(String name, int startMethodRow, int startMethodCol) {
        NameTok nameTok = new NameTok(name, 1);
        FunctionDef functionDef = new FunctionDef(nameTok, null, null, null, null);
        functionDef.beginLine = startMethodRow;
        functionDef.beginColumn = startMethodCol;
        this.addToPertinentScope(functionDef);
    }

    private void startClass(String name, int startClassRow, int startClassCol) {
        NameTok nameTok = new NameTok(name, 1);
        ClassDef classDef = new ClassDef(nameTok, null, null, null, null, null, null);
        classDef.beginLine = startClassRow;
        classDef.beginColumn = startClassCol;
        this.stack.push((Object)classDef);
        this.stackBody.push(new ArrayList());
    }

    private void endScope() {
        ClassDef def = (ClassDef)this.stack.pop();
        List body = (List)this.stackBody.pop();
        def.body = body.toArray(new stmtType[body.size()]);
        this.addToPertinentScope(def);
    }

    private void addToPertinentScope(stmtType newStmt) {
        while (this.stack.size() > 0) {
            ClassDef parent = (ClassDef)this.stack.peek();
            if (parent.beginColumn < newStmt.beginColumn) {
                List peek = (List)this.stackBody.peek();
                if (newStmt instanceof FunctionDef) {
                    int size = peek.size();
                    if (size > 0) {
                        stmtType existing = (stmtType)peek.get(size - 1);
                        if (existing.beginColumn < newStmt.beginColumn) {
                            return;
                        }
                    }
                } else if (newStmt instanceof Assign) {
                    Assign assign = (Assign)newStmt;
                    exprType target = assign.targets[0];
                    int size = peek.size();
                    if (size > 0) {
                        stmtType existing = (stmtType)peek.get(size - 1);
                        if (existing.beginColumn < assign.beginColumn && existing instanceof FunctionDef) {
                            FunctionDef functionDef = (FunctionDef)existing;
                            if (target instanceof Attribute) {
                                this.addAssignToFunctionDef(assign, functionDef);
                            }
                            return;
                        }
                    }
                    boolean cfr_ignored_0 = target instanceof Name;
                }
                peek.add(newStmt);
                return;
            }
            this.endScope();
        }
        this.body.add(newStmt);
    }

    private void addAssignToFunctionDef(Assign assign, FunctionDef functionDef) {
        if (functionDef.body == null) {
            if (functionDef.specialsAfter == null) {
                functionDef.specialsAfter = new ArrayList();
            }
            functionDef.body = new stmtType[10];
            functionDef.body[0] = assign;
            functionDef.specialsAfter.add(Autobox.valueOf((int)1));
        } else {
            Integer currLen = (Integer)functionDef.specialsAfter.get(0);
            currLen = Autobox.valueOf((int)(currLen + 1));
            functionDef.specialsAfter.set(0, currLen);
            if (functionDef.body.length < currLen) {
                stmtType[] newBody = new stmtType[functionDef.body.length * 2];
                System.arraycopy(functionDef.body, 0, newBody, 0, functionDef.body.length);
                functionDef.body = newBody;
            }
            functionDef.body[currLen.intValue() - 1] = assign;
        }
    }

    private boolean matchClass() {
        if (this.currIndex + 5 > this.length) {
            return false;
        }
        return this.cs[this.currIndex + 1] == 'l' && this.cs[this.currIndex + 2] == 'a' && this.cs[this.currIndex + 3] == 's' && this.cs[this.currIndex + 4] == 's' && Character.isWhitespace(this.cs[this.currIndex + 5]);
    }

    private boolean matchFunction() {
        if (this.currIndex + 3 > this.length) {
            return false;
        }
        return this.cs[this.currIndex + 1] == 'e' && this.cs[this.currIndex + 2] == 'f' && Character.isWhitespace(this.cs[this.currIndex + 3]);
    }

    public static SimpleNode parse(String s, String moduleName) {
        return FastDefinitionsParser.parse(s.toCharArray(), moduleName);
    }

    public static SimpleNode parse(char[] cs, String moduleName) {
        FastDefinitionsParser parser = new FastDefinitionsParser(cs);
        try {
            parser.extractBody();
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
        catch (StackOverflowError e) {
            Log.log((String)("Error parsing: " + moduleName + "\nContents:\n" + new String(cs)), (Throwable)e);
            throw new RuntimeException(e);
        }
        ArrayList<stmtType> body = parser.body;
        Module ret = new Module(body.toArray(new stmtType[body.size()]));
        if (parseCallbacks.size() > 0) {
            Tuple arg = new Tuple((Object)moduleName, (Object)ret);
            Iterator<ICallback<Object, Tuple<String, SimpleNode>>> iterator = parseCallbacks.iterator();
            while (iterator.hasNext()) {
                ICallback<Object, Tuple<String, SimpleNode>> c = iterator.next();
                c.call((Object)arg);
            }
        }
        return ret;
    }

    public static SimpleNode parse(String s) {
        return FastDefinitionsParser.parse(s.toCharArray(), null);
    }
}

