/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser;

import com.rc.retroweaver.runtime.Autobox;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.DocUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.parser.IParserObserver;
import org.python.pydev.core.parser.IParserObserver2;
import org.python.pydev.core.parser.IPyParser;
import org.python.pydev.core.parser.ISimpleNode;
import org.python.pydev.parser.CompilerAPI;
import org.python.pydev.parser.IGrammar;
import org.python.pydev.parser.ParserScheduler;
import org.python.pydev.parser.grammar24.PythonGrammar24;
import org.python.pydev.parser.grammar25.PythonGrammar25;
import org.python.pydev.parser.jython.CharStream;
import org.python.pydev.parser.jython.FastCharStream;
import org.python.pydev.parser.jython.IParserHost;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.ReaderCharStream;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.TokenMgrError;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.commentType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyParser
implements IPyParser {
    public static boolean ACCEPT_NULL_INPUT_EDITOR = false;
    public static boolean USE_FAST_STREAM = true;
    public static boolean TRY_REPARSE = true;
    private volatile IDocument document;
    private SimpleNode root = null;
    private IDocumentListener documentListener;
    private ArrayList<IParserObserver> parserListeners;
    public static boolean ENABLE_TRACING = false;
    private ParserScheduler scheduler;
    private boolean useAnalysisOnlyOnDocSave;
    private IGrammarVersionProvider grammarVersionProvider;
    private IEditorInput input;

    public static String getGrammarVersionStr(int grammarVersion) {
        if (grammarVersion == 10) {
            return "grammar: Python 2.4";
        }
        if (grammarVersion == 11) {
            return "grammar: Python 2.5";
        }
        return "grammar: unrecognized";
    }

    PyParser(IGrammarVersionProvider grammarVersionProvider) {
        if (grammarVersionProvider == null) {
            grammarVersionProvider = new IGrammarVersionProvider(){

                public int getGrammarVersion() {
                    return 11;
                }
            };
        }
        this.grammarVersionProvider = grammarVersionProvider;
        this.parserListeners = new ArrayList();
        this.scheduler = new ParserScheduler(this);
        this.documentListener = new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                String text = event.getText();
                boolean parseNow = true;
                if (event == null || text == null) {
                    parseNow = false;
                }
                if (parseNow && text.indexOf("\n") == -1 && text.indexOf("\r") == -1) {
                    parseNow = false;
                }
                if (!parseNow) {
                    if (!PyParser.this.useAnalysisOnlyOnDocSave) {
                        PyParser.this.scheduler.parseLater();
                    }
                } else if (!PyParser.this.useAnalysisOnlyOnDocSave) {
                    PyParser.this.scheduler.parseNow();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        };
    }

    public PyParser(IPyEdit editorView) {
        this((IGrammarVersionProvider)editorView.getPythonNature());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            this.parserListeners.clear();
        }
    }

    public SimpleNode getRoot() {
        return this.root;
    }

    public void notifySaved() {
        this.forceReparse(new Object[0]);
    }

    public void forceReparse(Object ... argsToReparse) {
        this.scheduler.parseNow(true, argsToReparse);
    }

    public void setDocument(IDocument document, IEditorInput input) {
        this.setDocument(document, true, input);
    }

    public synchronized void setDocument(IDocument doc, boolean addToScheduler, IEditorInput input) {
        this.input = input;
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        this.document = doc;
        if (doc == null) {
            System.err.println("No document in PyParser::setDocument?");
            return;
        }
        doc.addDocumentListener(this.documentListener);
        if (addToScheduler) {
            this.scheduler.parseNow(true, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParseListener(IParserObserver listener) {
        Assert.isNotNull((Object)listener);
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            if (!this.parserListeners.contains(listener)) {
                this.parserListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParseListener(IParserObserver listener) {
        Assert.isNotNull((Object)listener);
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            this.parserListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireParserChanged(SimpleNode root, IAdaptable file, IDocument doc, Object ... argsToReparse) {
        this.root = root;
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            for (IParserObserver l : new ArrayList<IParserObserver>(this.parserListeners)) {
                if (l instanceof IParserObserver2) {
                    ((IParserObserver2)l).parserChanged((ISimpleNode)root, file, doc, argsToReparse);
                    continue;
                }
                l.parserChanged((ISimpleNode)root, file, doc);
            }
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.parser.pydev_parser_observer");
            for (IParserObserver observer : participants) {
                if (observer instanceof IParserObserver2) {
                    ((IParserObserver2)observer).parserChanged((ISimpleNode)root, file, doc, argsToReparse);
                    continue;
                }
                observer.parserChanged((ISimpleNode)root, file, doc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireParserError(Throwable error, IAdaptable file, IDocument doc, Object ... argsToReparse) {
        ArrayList<IParserObserver> arrayList = this.parserListeners;
        synchronized (arrayList) {
            for (IParserObserver l : new ArrayList<IParserObserver>(this.parserListeners)) {
                if (l instanceof IParserObserver2) {
                    ((IParserObserver2)l).parserError(error, file, doc, argsToReparse);
                    continue;
                }
                l.parserError(error, file, doc);
            }
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.parser.pydev_parser_observer");
            for (IParserObserver observer : participants) {
                if (observer instanceof IParserObserver2) {
                    ((IParserObserver2)observer).parserError(error, file, doc, argsToReparse);
                    continue;
                }
                observer.parserError(error, file, doc);
            }
        }
    }

    public Tuple<SimpleNode, Throwable> reparseDocument(Object ... argsToReparse) {
        Tuple<SimpleNode, Throwable> obj = PyParser.reparseDocument(new ParserInfo(this.document, true, this.grammarVersionProvider.getGrammarVersion()));
        IFile original = null;
        Object adaptable = null;
        if (this.input == null) {
            return obj;
        }
        original = this.input instanceof IFileEditorInput ? ((IFileEditorInput)this.input).getFile() : null;
        adaptable = original != null ? original : this.input;
        if (original != null) {
            try {
                IMarker[] markers = original.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                if (markers.length > 0) {
                    original.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                }
            }
            catch (ResourceException e) {
                if (original.exists()) {
                    Log.log((Throwable)e);
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        } else if (adaptable == null && !ACCEPT_NULL_INPUT_EDITOR) {
            throw new RuntimeException("Null input editor received in parser!");
        }
        if (obj.o1 != null) {
            this.fireParserChanged((SimpleNode)obj.o1, (IAdaptable)adaptable, this.document, argsToReparse);
        }
        if (obj.o2 != null && obj.o2 instanceof ParseException) {
            this.fireParserError((ParseException)obj.o2, (IAdaptable)adaptable, this.document, argsToReparse);
        }
        if (obj.o2 != null && obj.o2 instanceof TokenMgrError) {
            this.fireParserError((TokenMgrError)obj.o2, (IAdaptable)adaptable, this.document, argsToReparse);
        }
        return obj;
    }

    public static List<commentType> removeEndingComments(IDocument doc) {
        StringBuffer comments = new StringBuffer();
        int lines = doc.getNumberOfLines();
        String delimiter = PySelection.getDelimiter((IDocument)doc);
        int i = lines - 1;
        while (i >= 0) {
            String line = PySelection.getLine((IDocument)doc, (int)i);
            String trimmed = line.trim();
            if (trimmed.length() > 0 && trimmed.charAt(0) != '#') {
                return PyParser.makeListOfComments(comments, line.length() + 2, i + 1);
            }
            comments.insert(0, line);
            comments.insert(0, delimiter);
            try {
                if (line.length() > 0) {
                    PySelection.deleteLine((IDocument)doc, (int)i);
                }
            }
            catch (Exception exception) {}
            --i;
        }
        return PyParser.makeListOfComments(comments, 0, 0);
    }

    private static List<commentType> makeListOfComments(StringBuffer comments, int beginCol, int beginLine) {
        ArrayList<commentType> ret = new ArrayList<commentType>();
        int len = comments.length();
        StringBuffer buf = null;
        int col = 0;
        int line = 0;
        int startCol = -1;
        int i = 0;
        while (i < len) {
            char c = comments.charAt(i);
            if (buf == null && c == '#') {
                buf = new StringBuffer();
                startCol = col;
            }
            if (c == '\r') {
                if (i < len - 1 && comments.charAt(i + 1) == '\n') {
                    ++i;
                }
                PyParser.addCommentLine(ret, buf, beginCol, beginLine, startCol, line);
                buf = null;
                col = 0;
                ++line;
                startCol = -1;
            }
            if (c == '\n') {
                PyParser.addCommentLine(ret, buf, beginCol, beginLine, startCol, line);
                buf = null;
                col = 0;
                ++line;
                startCol = -1;
            }
            if (buf != null) {
                buf.append(c);
            }
            ++col;
            ++i;
        }
        if (buf != null && buf.length() != 0) {
            PyParser.addCommentLine(ret, buf, beginCol, beginLine, startCol, line);
        }
        return ret;
    }

    private static void addCommentLine(ArrayList<commentType> ret, StringBuffer buf, int beginCol, int beginLine, int col, int line) {
        if (buf != null) {
            commentType comment = new commentType(buf.toString());
            comment.beginLine = beginLine + line;
            comment.beginColumn = line == 0 ? beginCol + col : col;
            ret.add(comment);
        }
    }

    public static Tuple<SimpleNode, Throwable> reparseDocument(ParserInfo info) {
        String startDoc = info.document.get();
        if (info.initial == null) {
            info.initial = startDoc;
        }
        Document newDoc = new Document(startDoc);
        List<commentType> comments = PyParser.removeEndingComments((IDocument)newDoc);
        try {
            newDoc.replace(newDoc.getLength(), 0, "\n");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CharStream in = null;
        if (!USE_FAST_STREAM) {
            String initialDoc = newDoc.get();
            StringReader inString = new StringReader(initialDoc);
            in = new ReaderCharStream(inString);
            throw new RuntimeException("This char stream reader was deprecated (was maintained only for testing purposes).");
        }
        char[] cs = newDoc.get().toCharArray();
        in = new FastCharStream(cs);
        CompilerAPI host = new CompilerAPI();
        IGrammar grammar = null;
        if (info.grammarVersion == 10) {
            grammar = new PythonGrammar24(in, (IParserHost)host);
        } else if (info.grammarVersion == 11) {
            grammar = new PythonGrammar25(in, (IParserHost)host);
        } else {
            throw new RuntimeException(new StringBuffer("The grammar specified for parsing is not valid: ").append(info.grammarVersion).toString());
        }
        try {
            SimpleNode newRoot;
            if (ENABLE_TRACING) {
                grammar.enable_tracing();
            }
            if ((newRoot = grammar.file_input()) != null) {
                Module m = (Module)newRoot;
                for (commentType comment : comments) {
                    m.addSpecial(comment, true);
                }
            }
            return new Tuple((Object)newRoot, null);
        }
        catch (Throwable e) {
            startDoc = null;
            newDoc = null;
            comments = null;
            in = null;
            host = null;
            grammar = null;
            if (e instanceof ParseException) {
                ParseException parseErr = (ParseException)e;
                SimpleNode newRoot = null;
                if (info.parseErr == null) {
                    info.parseErr = parseErr;
                }
                if (info.tryReparse) {
                    if (info.stillTryToChangeCurrentLine) {
                        newRoot = PyParser.tryReparseAgain(info, info.parseErr);
                    } else {
                        info.currentLine = -1;
                        info.document = new Document(info.initial);
                        newRoot = PyParser.tryReparseAgain(info, info.parseErr);
                    }
                }
                return new Tuple(newRoot, (Object)parseErr);
            }
            if (e instanceof TokenMgrError) {
                TokenMgrError tokenErr = (TokenMgrError)e;
                SimpleNode newRoot = null;
                if (info.tryReparse && info.stillTryToChangeCurrentLine) {
                    newRoot = PyParser.tryReparseAgain(info, tokenErr);
                }
                return new Tuple(newRoot, (Object)tokenErr);
            }
            if (e.getClass().getName().indexOf("LookaheadSuccess") == -1) {
                Log.log((Throwable)e);
            }
            return new Tuple(null, null);
        }
    }

    private static SimpleNode tryReparseAgain(ParserInfo info, TokenMgrError tokenErr) {
        int line = -1;
        line = info.currentLine > -1 ? info.currentLine : tokenErr.errorLine;
        return PyParser.tryReparseChangingLine(info, line);
    }

    private static SimpleNode tryReparseAgain(ParserInfo info, ParseException tokenErr) {
        int line = -1;
        if (info.currentLine > -1) {
            line = info.currentLine;
        } else if (tokenErr.currentToken != null) {
            line = tokenErr.currentToken.beginLine - 2;
        } else {
            return null;
        }
        if (line < 0) {
            line = 0;
        }
        boolean okToGo = false;
        while (!okToGo) {
            if (!PyParser.lineIn(info.linesChanged, line)) {
                info.linesChanged.add(new Integer(line));
                okToGo = true;
            }
            if (okToGo) continue;
            if (info.linesChanged.size() < 5) {
                ++line;
                continue;
            }
            return null;
        }
        return PyParser.tryReparseChangingLine(info, line);
    }

    private static boolean lineIn(Set<Integer> linesChanged, int line) {
        return linesChanged.contains(Autobox.valueOf((int)line));
    }

    private static SimpleNode tryReparseChangingLine(ParserInfo info, int line) {
        String docToParse = DocUtils.getDocToParseFromLine((IDocument)info.document, (int)line);
        if (docToParse != null) {
            Document doc = new Document(docToParse);
            info.document = doc;
            info.stillTryToChangeCurrentLine = false;
            return (SimpleNode)PyParser.reparseDocument((ParserInfo)info).o1;
        }
        return null;
    }

    public void resetTimeoutPreferences(boolean useAnalysisOnlyOnDocSave) {
        this.useAnalysisOnlyOnDocSave = useAnalysisOnlyOnDocSave;
    }

    public List<IParserObserver> getObservers() {
        return new ArrayList<IParserObserver>(this.parserListeners);
    }

    public static class ParserInfo {
        public IDocument document;
        public boolean stillTryToChangeCurrentLine = true;
        public int currentLine = -1;
        public String initial = null;
        public Set<Integer> linesChanged = new HashSet<Integer>();
        public ParseException parseErr;
        public boolean tryReparse = TRY_REPARSE;
        public int grammarVersion;

        public ParserInfo(IDocument document, boolean changedCurrentLine, int grammarVersion) {
            this.document = document;
            this.stillTryToChangeCurrentLine = changedCurrentLine;
            this.grammarVersion = grammarVersion;
        }

        public ParserInfo(IDocument document, boolean changedCurrentLine, IPythonNature nature) {
            this(document, changedCurrentLine, nature.getGrammarVersion());
        }

        public ParserInfo(IDocument document, boolean changedCurrentLine, IPythonNature nature, int currentLine) {
            this(document, changedCurrentLine, nature);
            this.currentLine = currentLine;
        }
    }
}

