/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammar24;

import org.python.pydev.core.structure.FastStack;
import org.python.pydev.parser.grammar24.IntStack;
import org.python.pydev.parser.grammar24.TreeBuilder24;
import org.python.pydev.parser.jython.Node;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;

class JJTPythonGrammar24State {
    private FastStack<SimpleNode> nodes = new FastStack();
    private IntStack marks = new IntStack();
    private IntStack lines = new IntStack();
    private IntStack columns = new IntStack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;
    TreeBuilder24 builder = new TreeBuilder24(this);

    JJTPythonGrammar24State() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    Node rootNode() {
        return (Node)this.nodes.getFirst();
    }

    void pushNode(SimpleNode n) {
        this.nodes.push((Object)n);
        ++this.sp;
    }

    SimpleNode popNode() {
        if (--this.sp < this.mk) {
            this.mk = this.marks.pop();
        }
        return (SimpleNode)this.nodes.pop();
    }

    SimpleNode peekNode() {
        return (SimpleNode)this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void pushNodePos(int line, int col) {
        this.lines.push(line);
        this.columns.push(col);
    }

    SimpleNode setNodePos() {
        SimpleNode n = this.peekNode();
        int popLine = this.lines.pop();
        if (n.beginLine == 0) {
            n.beginLine = popLine;
        }
        int popCol = this.columns.pop();
        if (n.beginColumn == 0) {
            n.beginColumn = popCol;
        }
        return n;
    }

    void clearNodeScope(Node n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = this.marks.pop();
    }

    void openNodeScope(Node n) {
        this.marks.push(this.mk);
        this.mk = this.sp;
    }

    void closeNodeScope(Node n, int num) throws ParseException {
        SimpleNode sn = (SimpleNode)n;
        this.mk = this.marks.pop();
        SimpleNode newNode = null;
        try {
            newNode = this.builder.closeNode(sn, num);
        }
        catch (ParseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new ParseException("Internal error:" + exc);
        }
        if (newNode == null) {
            throw new ParseException("Internal AST builder error");
        }
        this.pushNode(newNode);
        this.node_created = true;
    }

    void closeNodeScope(Node n, boolean condition) throws ParseException {
        SimpleNode sn = (SimpleNode)n;
        if (condition) {
            SimpleNode newNode = null;
            try {
                newNode = this.builder.closeNode(sn, this.nodeArity());
            }
            catch (ParseException exc) {
                throw exc;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new ParseException("Internal error:" + exc);
            }
            if (newNode == null) {
                throw new ParseException("Internal AST builder error");
            }
            this.mk = this.marks.size() > 0 ? this.marks.pop() : 0;
            this.pushNode(newNode);
            this.node_created = true;
        } else {
            this.mk = this.marks.pop();
            this.node_created = false;
        }
    }
}

