/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.core;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.refactoring.ast.PythonModuleManager;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringInfo {
    private IFile sourceFile;
    private IDocument doc;
    private ITextSelection userSelection;
    private ITextSelection extendedSelection;
    private ModuleAdapter moduleAdapter;
    private IPythonNature nature;
    private PythonModuleManager moduleManager;
    private AbstractScopeNode<?> scopeAdapter;

    public RefactoringInfo(ITextEditor edit, IPythonNature nature) {
        this(((IFileEditorInput)edit.getEditorInput()).getFile(), edit.getDocumentProvider().getDocument((Object)edit.getEditorInput()), (ITextSelection)edit.getSelectionProvider().getSelection(), nature);
    }

    public RefactoringInfo(IFile sourceFile, IDocument doc, ITextSelection selection, IPythonNature nature) {
        this.sourceFile = sourceFile;
        this.doc = doc;
        this.nature = nature;
        this.initInfo(selection, this.userSelection);
    }

    private void initInfo(ITextSelection selection, ITextSelection userSelection) {
        if (this.nature != null) {
            this.moduleManager = new PythonModuleManager(this.nature);
        }
        File realFile = null;
        if (this.sourceFile != null) {
            realFile = this.sourceFile.getRawLocation().toFile();
        }
        try {
            this.moduleAdapter = VisitorFactory.createModuleAdapter(this.moduleManager, realFile, this.doc, this.nature);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        this.extendedSelection = null;
        this.userSelection = this.moduleAdapter.normalizeSelection(selection);
    }

    public ModuleAdapter getModule() {
        return this.moduleAdapter;
    }

    public List<IClassDefAdapter> getClasses() {
        return this.moduleAdapter.getClasses();
    }

    public IFile getSourceFile() {
        return this.sourceFile;
    }

    public IDocument getDocument() {
        return this.doc;
    }

    public ITextSelection getExtendedSelection() {
        if (this.extendedSelection == null) {
            this.extendedSelection = new TextSelection(this.doc, this.getUserSelection().getOffset(), this.userSelection.getLength());
            if (this.getScopeAdapter() != null) {
                this.extendedSelection = this.moduleAdapter.normalizeSelection(VisitorFactory.createSelectionExtension(this.getScopeAdapter(), this.extendedSelection));
            }
        }
        return this.extendedSelection;
    }

    public ITextSelection getUserSelection() {
        return this.userSelection;
    }

    public ModuleAdapter getParsedExtendedSelection() {
        return this.getParsedExtendedSelection(this.getScopeAdapter());
    }

    public ModuleAdapter getParsedUserSelection() {
        ModuleAdapter parsedAdapter = null;
        String source = this.normalizeSourceSelection(this.getScopeAdapter(), this.userSelection);
        if (this.userSelection != null && source.length() > 0) {
            try {
                parsedAdapter = VisitorFactory.createModuleAdapter(this.moduleManager, null, (IDocument)new Document(source), this.nature);
            }
            catch (ParseException parseException) {}
        }
        return parsedAdapter;
    }

    private ModuleAdapter getParsedExtendedSelection(AbstractScopeNode<?> scopeNode) {
        ModuleAdapter parsedAdapter = null;
        String source = this.normalizeSourceSelection(scopeNode, this.getExtendedSelection());
        if (this.getExtendedSelection() != null && source.length() > 0) {
            try {
                parsedAdapter = VisitorFactory.createModuleAdapter(this.moduleManager, null, (IDocument)new Document(source), this.nature);
            }
            catch (ParseException parseException) {}
        }
        return parsedAdapter;
    }

    public String normalizeSourceSelection(AbstractScopeNode<?> scopeNode, ITextSelection selection) {
        String selectedText = "";
        if (selection.getText() != null) {
            selectedText = selection.getText().trim();
        }
        if (selectedText.length() == 0) {
            return "";
        }
        try {
            return this.normalizeBlockIndentation(selection, selectedText);
        }
        catch (Throwable throwable) {
            return selectedText;
        }
    }

    private String normalizeBlockIndentation(ITextSelection selection, String selectedText) throws Throwable {
        String[] lines = selectedText.split("\\n");
        if (lines.length < 2) {
            return selectedText;
        }
        String firstLine = this.doc.get(this.doc.getLineOffset(selection.getStartLine()), this.doc.getLineLength(selection.getStartLine()));
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
        String indentation = "";
        int bodyIndent = 0;
        while (firstLine.startsWith(" ")) {
            indentation = new StringBuffer(String.valueOf(indentation)).append(" ").toString();
            firstLine = firstLine.substring(1);
            ++bodyIndent;
        }
        if (bodyIndent > 0) {
            StringBuffer selectedCode = new StringBuffer();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith(indentation)) {
                    selectedCode.append(new StringBuffer(String.valueOf(line.substring(bodyIndent))).append(lineDelimiter).toString());
                } else {
                    selectedCode.append(new StringBuffer(String.valueOf(line)).append(lineDelimiter).toString());
                }
                ++n2;
            }
            selectedText = selectedCode.toString();
        }
        return selectedText;
    }

    public IClassDefAdapter getScopeClass() {
        return this.moduleAdapter.getScopeClass(this.getUserSelection());
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public List<IClassDefAdapter> getScopeClassAndBases() {
        return this.moduleAdapter.getClassHierarchy(this.getScopeClass());
    }

    public AbstractScopeNode<?> getScopeAdapter() {
        if (this.scopeAdapter == null) {
            this.scopeAdapter = this.moduleAdapter.getScopeAdapter(this.getUserSelection());
        }
        return this.scopeAdapter;
    }

    public boolean isSelectionExtensionRequired() {
        return this.getUserSelection().getOffset() != this.getExtendedSelection().getOffset() || this.getUserSelection().getLength() != this.getExtendedSelection().getLength();
    }

    public String getNewLineDelim() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
    }
}

