/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.jython;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.python.core.PyException;
import org.python.core.PyJavaClass;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.bundle.BundleInfo;
import org.python.pydev.core.bundle.IBundleInfo;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.jython.ExitScriptException;
import org.python.pydev.jython.IInteractiveConsole;
import org.python.pydev.jython.IPythonInterpreter;
import org.python.pydev.jython.InteractiveConsoleWrapper;
import org.python.pydev.jython.PythonInterpreterWrapper;
import org.python.pydev.jython.ScriptOutput;
import org.python.pydev.jython.ui.JyScriptingPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonPlugin
extends AbstractUIPlugin {
    private static final boolean DEBUG = false;
    public static boolean DEBUG_RELOAD = true;
    public static boolean IN_TESTS = false;
    private static String LOAD_FILE_SCRIPT = "print '--->  reloading', r'%s'\nimport sys                    \nf = open(r'%s')               \ntry:                          \n    toExec = f.read()         \nfinally:                      \n    f.close()                 \n%s                            \n";
    public static IBundleInfo info;
    private static JythonPlugin plugin;
    AllBundleClassLoader allBundleClassLoader;
    private static Map<File, Tuple<Long, Object>> codeCache;
    private static MessageConsole fConsole;
    static Color red;
    static Color black;
    static Color green;

    static {
        codeCache = new HashMap<File, Tuple<Long, Object>>();
    }

    public static synchronized void setDebugReload(boolean b) {
        if (b != DEBUG_RELOAD) {
            LOAD_FILE_SCRIPT = !b ? new StringBuffer("#").append(LOAD_FILE_SCRIPT).toString() : LOAD_FILE_SCRIPT.substring(1);
            DEBUG_RELOAD = b;
        }
    }

    public static IBundleInfo getBundleInfo() {
        if (info == null) {
            info = new BundleInfo(JythonPlugin.getDefault().getBundle());
        }
        return info;
    }

    public static void setBundleInfo(IBundleInfo b) {
        info = b;
    }

    public JythonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Properties prop2 = new Properties();
        prop2.put("python.home", REF.getFileAbsolutePath((File)this.getPluginRootDir()));
        prop2.put("python.path", REF.getFileAbsolutePath((File)JythonPlugin.getJySrcDirFile()));
        prop2.put("python.security.respectJavaAccessibility", "false");
        try {
            this.allBundleClassLoader = new AllBundleClassLoader(context.getBundles(), ((Object)((Object)this)).getClass().getClassLoader());
            PySystemState.initialize((Properties)System.getProperties(), (Properties)prop2, (String[])new String[0], (ClassLoader)this.allBundleClassLoader);
            String[] packageNames = JythonPlugin.getDefault().allBundleClassLoader.getPackageNames();
            int i = 0;
            while (i < packageNames.length) {
                PySystemState.add_package((String)packageNames[i]);
                ++i;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private File getPluginRootDir() {
        try {
            Path relative = new Path(".");
            return JythonPlugin.getBundleInfo().getRelativePath((IPath)relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static JythonPlugin getDefault() {
        return plugin;
    }

    public static File getJythonLibDir() {
        try {
            Path relative = new Path("Lib");
            return JythonPlugin.getBundleInfo().getRelativePath((IPath)relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File getFileWithinJySrc(String f) {
        try {
            IPath relative = new Path("jysrc").addTrailingSeparator().append(f);
            return JythonPlugin.getBundleInfo().getRelativePath(relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File getJySrcDirFile() {
        try {
            Path relative = new Path("jysrc");
            return JythonPlugin.getBundleInfo().getRelativePath((IPath)relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Throwable exec(HashMap<String, Object> locals, String fileToExec, IPythonInterpreter interpreter) {
        File fileWithinJySrc = JythonPlugin.getFileWithinJySrc(fileToExec);
        return JythonPlugin.exec(locals, interpreter, fileWithinJySrc, new File[]{fileWithinJySrc.getParentFile()});
    }

    public static List<Throwable> execAll(HashMap<String, Object> locals, String startingWith, IPythonInterpreter interpreter) {
        File jySrc = JythonPlugin.getJySrcDirFile();
        File additionalScriptingLocation = JyScriptingPreferencesPage.getAdditionalScriptingLocation();
        return JythonPlugin.execAll(locals, startingWith, interpreter, new File[]{jySrc, additionalScriptingLocation});
    }

    public static List<Throwable> execAll(HashMap<String, Object> locals, String startingWith, IPythonInterpreter interpreter, File[] beneathFolders) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        File[] fileArray = beneathFolders;
        int n = beneathFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file != null) {
                File[] files;
                if (!file.exists()) {
                    String msg = new StringBuffer("The folder:").append(file).append(" does not exist and therefore cannot be used to ").append("find scripts to run starting with:").append(startingWith).toString();
                    Log.log((int)4, (String)msg, null);
                    errors.add(new RuntimeException(msg));
                }
                if ((files = JythonPlugin.getFilesBeneathFolder(startingWith, file)) != null) {
                    File[] fileArray2 = files;
                    int n3 = files.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File f = fileArray2[n4];
                        Throwable throwable = JythonPlugin.exec(locals, interpreter, f, beneathFolders);
                        if (throwable != null) {
                            errors.add(throwable);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return errors;
    }

    public static File[] getFilesBeneathFolder(final String startingWith, File jySrc) {
        File[] files = jySrc.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.startsWith(startingWith) && name.endsWith(".py");
            }
        });
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized Throwable exec(HashMap<String, Object> locals, IPythonInterpreter interpreter, File fileToExec, File[] pythonpathFolders) {
        if (locals == null) {
            locals = new HashMap();
        }
        Map<File, Tuple<Long, Object>> map = codeCache;
        synchronized (map) {
            try {
                String fileName = fileToExec.getName();
                if (!fileName.endsWith(".py")) {
                    throw new RuntimeException(new StringBuffer("The script to be executed must be a python file. Name:").append(fileName).toString());
                }
                String codeObjName = new StringBuffer("code").append(fileName.substring(0, fileName.indexOf(46))).toString();
                String codeObjTimestampName = new StringBuffer(String.valueOf(codeObjName)).append("Timestamp").toString();
                for (Map.Entry<String, Object> entry : locals.entrySet()) {
                    interpreter.set(entry.getKey(), entry.getValue());
                }
                boolean regenerate = false;
                Tuple<Long, Object> timestamp = codeCache.get(fileToExec);
                long lastModified = fileToExec.lastModified();
                if (timestamp == null || (Long)timestamp.o1 != lastModified) {
                    regenerate = true;
                }
                if (!regenerate) {
                    PyObject obj = interpreter.get(codeObjName);
                    PyObject pyTime = interpreter.get(codeObjTimestampName);
                    if (obj == null || pyTime == null || !pyTime.__tojava__(ClassLiteral.getClass((String)"java/lang/Long")).equals(timestamp.o1)) {
                        interpreter.set(codeObjName, timestamp.o2);
                        interpreter.set(codeObjTimestampName, timestamp.o1);
                    }
                }
                if (regenerate) {
                    String path = REF.getFileAbsolutePath((File)fileToExec);
                    StringBuffer strPythonPathFolders = new StringBuffer();
                    strPythonPathFolders.append("[");
                    File[] fileArray = pythonpathFolders;
                    int n = pythonpathFolders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file != null) {
                            strPythonPathFolders.append("r'");
                            strPythonPathFolders.append(REF.getFileAbsolutePath((File)file));
                            strPythonPathFolders.append("',");
                        }
                        ++n2;
                    }
                    strPythonPathFolders.append("]");
                    StringBuffer addToSysPath = new StringBuffer();
                    addToSysPath.append("if not hasattr(sys, 'PYDEV_PYTHONPATH_SET') or sys.PYDEV_PYTHONPATH_SET != ");
                    addToSysPath.append(strPythonPathFolders);
                    addToSysPath.append(":\n");
                    addToSysPath.append("    sys.PYDEV_PYTHONPATH_SET = ");
                    addToSysPath.append(strPythonPathFolders);
                    addToSysPath.append("\n");
                    addToSysPath.append("    sys.path += ");
                    addToSysPath.append(strPythonPathFolders);
                    addToSysPath.append("\n");
                    String toExec = StringUtils.format((String)LOAD_FILE_SCRIPT, (Object[])new Object[]{path, path, addToSysPath.toString()});
                    interpreter.exec(toExec);
                    String exec = StringUtils.format((String)"%s = compile(toExec, r'%s', 'exec')", (Object[])new Object[]{codeObjName, path});
                    interpreter.exec(exec);
                    interpreter.set(codeObjTimestampName, Autobox.valueOf((long)lastModified));
                    PyObject codeObj = interpreter.get(codeObjName);
                    codeCache.put(fileToExec, (Tuple<Long, Object>)new Tuple((Object)Autobox.valueOf((long)lastModified), (Object)codeObj));
                }
                interpreter.exec(StringUtils.format((String)"exec(%s)", (Object[])new Object[]{codeObjName}));
            }
            catch (Throwable e) {
                if (!IN_TESTS && JythonPlugin.getDefault() == null) {
                    return null;
                }
                if (e instanceof ExitScriptException) {
                    return null;
                }
                if (e instanceof PyException) {
                    PyException pE = (PyException)e;
                    if (pE.type instanceof PyJavaClass) {
                        PyJavaClass t = (PyJavaClass)pE.type;
                        if (t.__name__ != null && t.__name__.equals("org.python.pydev.jython.ExitScriptException")) {
                            return null;
                        }
                    }
                }
                if (!JyScriptingPreferencesPage.getShowScriptingOutput()) return e;
                Log.log((int)4, (String)new StringBuffer("Error while executing:").append(fileToExec).toString(), (Throwable)e);
                return e;
            }
            return null;
        }
    }

    private static MessageConsole getConsole() {
        try {
            if (fConsole == null) {
                fConsole = new MessageConsole("", JythonPlugin.getBundleInfo().getImageCache().getDescriptor("icons/python.gif"));
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{fConsole});
            }
            return fConsole;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IPythonInterpreter newPythonInterpreter() {
        return JythonPlugin.newPythonInterpreter(true);
    }

    public static IPythonInterpreter newPythonInterpreter(boolean redirect) {
        PythonInterpreterWrapper interpreter = new PythonInterpreterWrapper();
        if (redirect) {
            interpreter.setOut(new ScriptOutput(JythonPlugin.getBlack(), JythonPlugin.getConsole()));
            interpreter.setErr(new ScriptOutput(JythonPlugin.getRed(), JythonPlugin.getConsole()));
        }
        interpreter.set("False", Autobox.valueOf((int)0));
        interpreter.set("True", Autobox.valueOf((int)1));
        return interpreter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getRed() {
        if (red == null) {
            Display display = Display.getDefault();
            synchronized (display) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        red = Display.getDefault().getSystemColor(3);
                    }
                });
            }
        }
        return red;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getBlack() {
        if (black == null) {
            Display display = Display.getDefault();
            synchronized (display) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        black = Display.getDefault().getSystemColor(2);
                    }
                });
            }
        }
        return black;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getGreen() {
        if (green == null) {
            Display display = Display.getDefault();
            synchronized (display) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        green = new Color((Device)Display.getDefault(), 0, 200, 125);
                    }
                });
            }
        }
        return green;
    }

    public static IInteractiveConsole newInteractiveConsole() {
        return new InteractiveConsoleWrapper();
    }

    public static class AllBundleClassLoader
    extends ClassLoader {
        private Bundle[] bundles;
        private String[] packageNames;

        public AllBundleClassLoader(Bundle[] bundles, ClassLoader parent) {
            super(parent);
            this.bundles = bundles;
            this.setPackageNames(bundles);
        }

        /*
         * Unable to fully structure code
         */
        public Class loadClass(String className) throws ClassNotFoundException {
            try {
                return super.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                i = 0;
                ** while (i < this.bundles.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    if (this.bundles[i].getState() == 32) {
                        return this.bundles[i].loadClass(className);
                    }
                }
                catch (Throwable v0) {}
                ++i;
                continue;
            }
lbl13:
            // 1 sources

            throw e;
        }

        private void setPackageNames(Bundle[] bundles) {
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            while (i < bundles.length) {
                int j;
                String[] pnames;
                String packages = (String)bundles[i].getHeaders().get("Provide-Package");
                if (packages != null) {
                    pnames = packages.split(",");
                    j = 0;
                    while (j < pnames.length) {
                        names.add(pnames[j].trim());
                        ++j;
                    }
                }
                if ((packages = (String)bundles[i].getHeaders().get("Export-Package")) != null) {
                    pnames = packages.split(",");
                    j = 0;
                    while (j < pnames.length) {
                        names.add(pnames[j].trim());
                        ++j;
                    }
                }
                ++i;
            }
            this.packageNames = names.toArray(new String[names.size()]);
        }

        public String[] getPackageNames() {
            return this.packageNames;
        }
    }
}

