/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.python.pydev.debug.codecoverage.ErrorFileNode;
import org.python.pydev.debug.codecoverage.FileNode;
import org.python.pydev.debug.codecoverage.FolderNode;
import org.python.pydev.debug.codecoverage.NodeNotFoudException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageCache {
    public Map<Object, Object> folders = new HashMap<Object, Object>();
    public Map<Object, Object> files = new HashMap<Object, Object>();

    public void addFolder(Object node) {
        FolderNode c = new FolderNode();
        c.node = node;
        this.folders.put(node, c);
    }

    public void addFolder(Object node, Object parent) {
        FolderNode parentNode = (FolderNode)this.getFolder(parent);
        FolderNode newNode = new FolderNode();
        newNode.node = node;
        if (parentNode == null) {
            throw new RuntimeException(new StringBuffer("The folder being added:").append(node.toString()).append(" didn't have its parent found.").toString());
        }
        parentNode.subFolders.put(node, newNode);
        this.folders.put(node, newNode);
    }

    public Object getFolder(Object obj) {
        return this.getIt(obj, this.folders);
    }

    public Object getFile(Object obj) {
        return this.getIt(obj, this.files);
    }

    private Object getIt(Object obj, Map<Object, Object> m) {
        Object object = m.get(obj);
        if (object == null) {
            for (Object element : m.keySet()) {
                if (!element.equals(obj)) continue;
                return m.get(element);
            }
        }
        return object;
    }

    public void addFile(Object node, Object parent, int stmts, int exec, String notExecuted) {
        FolderNode folderNode = (FolderNode)this.getFolder(parent);
        if (folderNode == null) {
            throw new RuntimeException(new StringBuffer("A file node (").append(node.toString()).append(")MUST have a related folder node.").toString());
        }
        FileNode fileNode = new FileNode();
        fileNode.exec = exec;
        fileNode.node = node;
        fileNode.notExecuted = notExecuted;
        fileNode.stmts = stmts;
        folderNode.files.put(node, fileNode);
        this.files.put(node, fileNode);
    }

    public void addFile(Object node, Object parent, String desc) {
        FolderNode folderNode = (FolderNode)this.getFolder(parent);
        if (folderNode == null) {
            throw new RuntimeException(new StringBuffer("A file node (").append(node.toString()).append(")MUST have a related folder node.").toString());
        }
        ErrorFileNode fileNode = new ErrorFileNode();
        fileNode.node = node;
        fileNode.desc = desc;
        folderNode.files.put(node, fileNode);
        this.files.put(node, fileNode);
    }

    public List<Object> getFiles(Object node) throws NodeNotFoudException {
        FolderNode folderNode = (FolderNode)this.getFolder(node);
        if (folderNode == null) {
            Object fileNode = this.getFile(node);
            if (fileNode == null) {
                throw new NodeNotFoudException(new StringBuffer("The node has not been found: ").append(node.toString()).toString());
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(fileNode);
            return list;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        this.recursivelyFillList(folderNode, list);
        return list;
    }

    private void recursivelyFillList(FolderNode folderNode, ArrayList<Object> list) {
        Iterator<Object> it = folderNode.files.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        it = folderNode.subFolders.values().iterator();
        while (it.hasNext()) {
            this.recursivelyFillList((FolderNode)it.next(), list);
        }
    }

    public String getStatistics(Object node) {
        StringBuffer buffer = new StringBuffer();
        try {
            List<Object> list = this.getFiles(node);
            buffer.append("Name                                    Stmts     Exec     Cover  Missing\n");
            buffer.append("-----------------------------------------------------------------------------\n");
            int totalExecuted = 0;
            int totalStmts = 0;
            for (Object element : list) {
                buffer.append(new StringBuffer(String.valueOf(element.toString())).append("\n").toString());
                if (!(element instanceof FileNode)) continue;
                totalExecuted += ((FileNode)element).exec;
                totalStmts += ((FileNode)element).stmts;
            }
            buffer.append("-----------------------------------------------------------------------------\n");
            buffer.append(new StringBuffer(String.valueOf(FileNode.toString("TOTAL", totalStmts, totalExecuted, ""))).append("\n").toString());
        }
        catch (NodeNotFoudException nodeNotFoudException) {
            buffer.append("File has no statistics.");
        }
        return buffer.toString();
    }

    public void clear() {
        this.folders.clear();
        this.files.clear();
    }
}

