/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.plugin.PydevPlugin;

public class ValueModificationChecker {
    private Map<String, Map<String, PyStackFrame>> cache = new HashMap<String, Map<String, PyStackFrame>>();
    private Object lock = new Object();

    private void verifyVariablesModified(IVariable[] newFrameVariables, PyStackFrame oldFrame) {
        PyVariable newVariable = null;
        try {
            Map<String, IVariable> variablesAsMap = oldFrame.getVariablesAsMap();
            int i = 0;
            while (i < newFrameVariables.length) {
                newVariable = (PyVariable)newFrameVariables[i];
                PyVariable oldVariable = (PyVariable)variablesAsMap.get(newVariable.getName());
                if (oldVariable != null) {
                    boolean equals = newVariable.getValueString().equals(oldVariable.getValueString());
                    newVariable.setModified(!equals);
                } else {
                    newVariable.setModified(true);
                }
                ++i;
            }
        }
        catch (DebugException e) {
            PydevPlugin.log((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyModified(PyStackFrame frame, IVariable[] newFrameVariables) {
        Object object = this.lock;
        synchronized (object) {
            PyStackFrame cacheFrame;
            Map<String, PyStackFrame> threadIdCache = this.cache.get(frame.getThreadId());
            if (threadIdCache == null) {
                threadIdCache = new HashMap<String, PyStackFrame>();
                this.cache.put(frame.getThreadId(), threadIdCache);
            }
            if ((cacheFrame = threadIdCache.get(frame.getId())) == null) {
                threadIdCache.put(frame.getId(), frame);
                return;
            }
            if (cacheFrame == frame) {
                return;
            }
            this.verifyVariablesModified(newFrameVariables, cacheFrame);
            threadIdCache.put(frame.getId(), frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onlyLeaveThreads(PyThread[] threads) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<String> ids = new HashSet<String>();
            PyThread[] pyThreadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                PyThread thread = pyThreadArray[n2];
                ids.add(thread.getId());
                ++n2;
            }
            Iterator<String> iterator = this.cache.keySet().iterator();
            while (iterator.hasNext()) {
                String id = iterator.next();
                if (ids.contains(id)) continue;
                this.cache.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onlyLeaveStack(PyThread t, IStackFrame[] stackFrame) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, PyStackFrame> threadIdCache = this.cache.get((Object)t);
            if (threadIdCache == null) {
                return;
            }
            HashSet<String> ids = new HashSet<String>();
            int i = 0;
            while (i < stackFrame.length) {
                ids.add(((PyStackFrame)stackFrame[i]).getId());
                ++i;
            }
            Iterator<String> iterator = threadIdCache.keySet().iterator();
            while (iterator.hasNext()) {
                String id = iterator.next();
                if (ids.contains(id)) continue;
                threadIdCache.remove(id);
            }
        }
    }
}

