/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import org.eclipse.core.runtime.CoreException;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;

public class ThreadListCommand
extends AbstractDebuggerCommand {
    boolean done;
    AbstractDebugTarget target;
    PyThread[] threads;

    public ThreadListCommand(AbstractRemoteDebugger debugger, AbstractDebugTarget target) {
        super(debugger);
        this.target = target;
        this.done = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone(int timeout) throws InterruptedException {
        while (!this.done && timeout > 0) {
            timeout -= 100;
            ThreadListCommand threadListCommand = this;
            synchronized (threadListCommand) {
                Thread.sleep(100L);
            }
        }
        if (timeout < 0) {
            throw new InterruptedException();
        }
    }

    public PyThread[] getThreads() {
        return this.threads;
    }

    public String getOutgoing() {
        return ThreadListCommand.makeCommand(102, this.sequence, "");
    }

    public boolean needResponse() {
        return true;
    }

    public void processOKResponse(int cmdCode, String payload) {
        if (cmdCode != 102) {
            PydevDebugPlugin.log(4, "Unexpected response to LIST THREADS" + payload, null);
            return;
        }
        try {
            this.threads = XMLUtils.ThreadsFromXML(this.target, payload);
        }
        catch (CoreException e) {
            PydevDebugPlugin.log(4, "LIST THREADS got an unexpected response " + payload, null);
            e.printStackTrace();
        }
        this.done = true;
    }

    public void processErrorResponse(int cmdCode, String payload) {
        PydevDebugPlugin.log(4, "LIST THREADS got an error " + payload, null);
    }
}

