/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.todo;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.PydevMarkerUtils;
import org.python.pydev.builder.todo.PyTodoPrefPage;
import org.python.pydev.plugin.PydevPlugin;

public class PyTodoVisitor
extends PyDevBuilderVisitor {
    public void visitChangedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        List<String> todoTags;
        if (document != null && (todoTags = PyTodoPrefPage.getTodoTags()).size() > 0) {
            int numberOfLines = document.getNumberOfLines();
            try {
                resource.deleteMarkers("org.eclipse.core.resources.taskmarker", false, 0);
                int line = 0;
                while (line < numberOfLines) {
                    IRegion region = document.getLineInformation(line);
                    String tok = document.get(region.getOffset(), region.getLength());
                    Iterator<String> iter = todoTags.iterator();
                    while (iter.hasNext()) {
                        String element = iter.next();
                        int index = tok.indexOf(element);
                        if (index == -1) continue;
                        PydevMarkerUtils.createMarker(resource, document, tok.substring(index).trim(), line, "org.eclipse.core.resources.taskmarker", 1, false, false, null);
                    }
                    ++line;
                }
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
    }

    public void visitRemovedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
    }
}

