/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.dltk.console.ui.internal;

import com.rc.retroweaver.runtime.Autobox;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.dltk.console.InterpreterResponse;
import org.python.pydev.dltk.console.ScriptConsoleHistory;
import org.python.pydev.dltk.console.ScriptConsolePrompt;
import org.python.pydev.dltk.console.ui.IConsoleStyleProvider;
import org.python.pydev.dltk.console.ui.ScriptConsolePartitioner;
import org.python.pydev.dltk.console.ui.ScriptStyleRange;
import org.python.pydev.dltk.console.ui.internal.ICommandHandler;
import org.python.pydev.dltk.console.ui.internal.IScriptConsoleViewer2ForDocumentListener;
import org.python.pydev.editor.autoedit.DocCmd;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptConsoleDocumentListener
implements IDocumentListener {
    private ICommandHandler handler;
    private ScriptConsolePrompt prompt;
    private ScriptConsoleHistory history;
    private int offset;
    private IDocument doc;
    private int disconnectionLevel = 0;
    private long lastChangeMillis;
    private String initialCommands;
    private IScriptConsoleViewer2ForDocumentListener viewer;
    private List<WeakReference<IScriptConsoleViewer2ForDocumentListener>> otherViewers = new ArrayList<WeakReference<IScriptConsoleViewer2ForDocumentListener>>();
    IDocument EMPTY_DOCUMENT = new Document();
    private PyAutoIndentStrategy strategy = new PyAutoIndentStrategy();
    private List<IConsoleLineTracker> consoleLineTrackers;

    public long getLastChangeMillis() {
        return this.lastChangeMillis;
    }

    public ScriptConsoleDocumentListener() {
        this.lastChangeMillis = System.currentTimeMillis();
    }

    public PyAutoIndentStrategy getIndentStrategy() {
        return this.strategy;
    }

    protected synchronized void reconnect(IDocument oldDoc, IDocument newDoc) {
        Assert.isTrue((this.disconnectionLevel == 0 ? 1 : 0) != 0);
        if (oldDoc != null) {
            oldDoc.removeDocumentListener((IDocumentListener)this);
        }
        newDoc.addDocumentListener((IDocumentListener)this);
        this.doc = newDoc;
    }

    protected synchronized void startDisconnected() {
        if (this.disconnectionLevel == 0) {
            this.doc.removeDocumentListener((IDocumentListener)this);
        }
        ++this.disconnectionLevel;
    }

    protected synchronized void stopDisconnected() {
        --this.disconnectionLevel;
        if (this.disconnectionLevel == 0) {
            this.doc.addDocumentListener((IDocumentListener)this);
        }
    }

    public void clear(boolean addInitialCommands) {
        try {
            this.startDisconnected();
            try {
                this.doc.set("");
                this.appendInvitation(true);
            }
            finally {
                this.stopDisconnected();
            }
        }
        catch (BadLocationException e) {
            PydevPlugin.log(e);
        }
        if (addInitialCommands) {
            try {
                this.doc.replace(this.doc.getLength(), 0, this.initialCommands);
            }
            catch (BadLocationException e) {
                PydevPlugin.log(e);
            }
        }
    }

    public void addViewer(IScriptConsoleViewer2ForDocumentListener scriptConsoleViewer) {
        this.otherViewers.add(new WeakReference<IScriptConsoleViewer2ForDocumentListener>(scriptConsoleViewer));
    }

    public ScriptConsoleDocumentListener(IScriptConsoleViewer2ForDocumentListener viewer, ICommandHandler handler, ScriptConsolePrompt prompt, ScriptConsoleHistory history, List<IConsoleLineTracker> consoleLineTrackers, String initialCommands) {
        this.prompt = prompt;
        this.handler = handler;
        this.history = history;
        this.viewer = viewer;
        this.offset = 0;
        this.doc = null;
        this.consoleLineTrackers = consoleLineTrackers;
        this.initialCommands = initialCommands;
    }

    public void setDocument(IDocument doc) {
        this.reconnect(this.doc, doc);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    protected void handleCommandLine() throws Exception {
        String command = this.getCommandLine();
        this.appendText(this.getDelimeter());
        this.processResult(this.handler.handleCommand(command));
    }

    protected void processResult(InterpreterResponse result) throws BadLocationException {
        if (result != null) {
            this.addToConsoleView(result.out, true);
            this.addToConsoleView(result.err, false);
            this.history.commit();
            this.offset = this.getLastLineLength();
        }
        this.appendInvitation(false);
    }

    private void addToConsoleView(String out, boolean stdout) throws BadLocationException {
        ScriptStyleRange style;
        if (out.length() == 0) {
            return;
        }
        int start = this.doc.getLength();
        IConsoleStyleProvider styleProvider = this.viewer.getStyleProvider();
        if (styleProvider != null && (style = stdout ? styleProvider.createInterpreterOutputStyle(out, start) : styleProvider.createInterpreterErrorStyle(out, start)) != null) {
            this.addToPartitioner(style);
        }
        this.appendText(out);
        PySelection ps = new PySelection(this.doc, start);
        int cursorLine = ps.getCursorLine();
        int numberOfLines = this.doc.getNumberOfLines();
        int i = cursorLine;
        while (i < numberOfLines) {
            try {
                int offset = ps.getLineOffset(i);
                int endOffset = ps.getEndLineOffset(i);
                Region region = new Region(offset, endOffset - offset);
                for (IConsoleLineTracker lineTracker : this.consoleLineTrackers) {
                    lineTracker.lineAppended((IRegion)region);
                }
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
            ++i;
        }
    }

    private void addToPartitioner(ScriptStyleRange style) {
        IDocumentPartitioner partitioner = this.doc.getDocumentPartitioner();
        if (partitioner instanceof ScriptConsolePartitioner) {
            ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
            scriptConsolePartitioner.addRange(style);
        }
    }

    protected void proccessAddition(int offset, String text) throws Exception {
        DocCmd docCmd;
        String indentString = "";
        boolean addedNewLine = false;
        boolean addedParen = false;
        boolean addedCloseParen = false;
        int addedLen = text.length();
        if (addedLen == 1) {
            if (text.equals("\r") || text.equals("\n")) {
                addedNewLine = true;
            } else if (text.equals("(")) {
                addedParen = true;
            } else if (text.equals(")")) {
                addedCloseParen = true;
            }
        } else if (addedLen == 2 && text.equals("\r\n")) {
            addedNewLine = true;
        }
        String delim = this.getDelimeter();
        int newDeltaCaretPosition = this.doc.getLength() - (offset + text.length());
        text = this.doc.get(offset, this.doc.getLength() - offset);
        this.doc.replace(offset, text.length(), "");
        text = text.replaceAll("\r\n|\n|\r", delim);
        int start = 0;
        int index = -1;
        while ((index = text.indexOf(delim, start)) != -1) {
            IDocument historyDoc;
            int currHistoryLen;
            String cmd = text.substring(start, index);
            cmd = this.convertTabs(cmd);
            this.applyStyleToUserAddedText(cmd, this.doc.getLength());
            this.appendText(cmd);
            String commandLine = this.getCommandLine();
            this.history.update(commandLine);
            start = index + delim.length();
            this.handleCommandLine();
            if (!addedNewLine || (currHistoryLen = (historyDoc = this.history.getAsDoc()).getLength()) <= 0) continue;
            docCmd = new DocCmd(currHistoryLen - 1, 0, delim);
            this.strategy.customizeNewLine(historyDoc, docCmd);
            indentString = docCmd.text.replaceAll("\\r\\n|\\n|\\r", "");
            if (currHistoryLen == historyDoc.getLength()) continue;
            PydevPlugin.log("Error: the document passed to the customizeNewLine should not be changed!");
        }
        boolean shiftsCaret = true;
        String newText = text.substring(start, text.length());
        if (addedParen) {
            Document parenDoc = new Document(new StringBuffer(String.valueOf(this.getCommandLine())).append("(").toString());
            int currentOffset = parenDoc.getLength();
            docCmd = new DocCmd(currentOffset, 0, "(");
            docCmd.shiftsCaret = true;
            this.strategy.customizeParenthesis((IDocument)parenDoc, docCmd);
            newText = docCmd.text;
            if (!docCmd.shiftsCaret) {
                shiftsCaret = false;
                this.setCaretOffset(offset + (docCmd.caretOffset - currentOffset));
            }
        } else if (addedCloseParen) {
            String cmdLine = this.getCommandLine();
            String existingDoc = new StringBuffer(String.valueOf(cmdLine)).append(text.substring(1)).toString();
            int cmdLineOffset = cmdLine.length();
            if (existingDoc.length() > cmdLineOffset) {
                Document parenDoc = new Document(existingDoc);
                DocCmd docCmd2 = new DocCmd(cmdLineOffset, 0, ")");
                docCmd2.shiftsCaret = true;
                boolean canSkipOpenParenthesis = this.strategy.canSkipOpenParenthesis((IDocument)parenDoc, docCmd2);
                if (canSkipOpenParenthesis) {
                    shiftsCaret = false;
                    this.setCaretOffset(offset + 1);
                    newText = newText.substring(1);
                }
            }
        }
        String cmd = new StringBuffer(String.valueOf(indentString)).append(newText).toString();
        cmd = this.convertTabs(cmd);
        this.applyStyleToUserAddedText(cmd, this.doc.getLength());
        this.appendText(cmd);
        if (shiftsCaret) {
            this.setCaretOffset(this.doc.getLength() - newDeltaCaretPosition);
        }
        this.history.update(this.getCommandLine());
    }

    private String convertTabs(String cmd) {
        DocCmd newStr = new DocCmd(0, 0, cmd);
        this.strategy.getIndentPrefs().convertToStd(this.EMPTY_DOCUMENT, newStr);
        cmd = newStr.text;
        return cmd;
    }

    private void applyStyleToUserAddedText(String cmd, int offset2) {
        ScriptStyleRange style;
        IConsoleStyleProvider styleProvider = this.viewer.getStyleProvider();
        if (styleProvider != null && (style = styleProvider.createUserInputStyle(cmd, offset2)) != null) {
            this.addToPartitioner(style);
        }
    }

    public void documentChanged(DocumentEvent event) {
        this.lastChangeMillis = System.currentTimeMillis();
        this.startDisconnected();
        try {
            int eventOffset = event.getOffset();
            String eventText = event.getText();
            try {
                this.proccessAddition(eventOffset, eventText);
            }
            catch (BadLocationException badLocationException) {
                System.out.println(StringUtils.format((String)"Error: bad location: offset:%s text:%s", (Object[])new Object[]{Autobox.valueOf((int)eventOffset), eventText}));
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
        finally {
            this.stopDisconnected();
        }
    }

    protected void appendText(String text) throws BadLocationException {
        int initialOffset = this.doc.getLength();
        this.doc.replace(initialOffset, 0, text);
    }

    protected void appendInvitation(boolean async) throws BadLocationException {
        ScriptStyleRange style;
        int start = this.doc.getLength();
        String promptStr = this.prompt.toString();
        IConsoleStyleProvider styleProvider = this.viewer.getStyleProvider();
        if (styleProvider != null && (style = styleProvider.createPromptStyle(promptStr, start)) != null) {
            this.addToPartitioner(style);
        }
        this.appendText(promptStr);
        this.setCaretOffset(this.doc.getLength(), async);
        this.revealEndOfDocument();
    }

    private void revealEndOfDocument() {
        this.viewer.revealEndOfDocument();
        Iterator<WeakReference<IScriptConsoleViewer2ForDocumentListener>> it = this.otherViewers.iterator();
        while (it.hasNext()) {
            WeakReference<IScriptConsoleViewer2ForDocumentListener> ref = it.next();
            IScriptConsoleViewer2ForDocumentListener v = (IScriptConsoleViewer2ForDocumentListener)ref.get();
            if (v == null) {
                it.remove();
                continue;
            }
            v.revealEndOfDocument();
        }
    }

    private void setCaretOffset(int offset) {
        this.setCaretOffset(offset, false);
    }

    private void setCaretOffset(int offset, boolean async) {
        this.viewer.setCaretOffset(offset, async);
        Iterator<WeakReference<IScriptConsoleViewer2ForDocumentListener>> it = this.otherViewers.iterator();
        while (it.hasNext()) {
            WeakReference<IScriptConsoleViewer2ForDocumentListener> ref = it.next();
            IScriptConsoleViewer2ForDocumentListener v = (IScriptConsoleViewer2ForDocumentListener)ref.get();
            if (v == null) {
                it.remove();
                continue;
            }
            v.setCaretOffset(offset, async);
        }
    }

    public String getDelimeter() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
    }

    public int getLastLineLength() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineLength(lastLine);
    }

    public int getLastLineOffset() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineOffset(lastLine);
    }

    public int getLastLineReadOnlySize() {
        return this.offset + this.prompt.toString().length();
    }

    public int getCommandLineOffset() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineOffset(lastLine) + this.getLastLineReadOnlySize();
    }

    public int getCommandLineLength() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineLength(lastLine) - this.getLastLineReadOnlySize();
    }

    public String getCommandLine() throws BadLocationException {
        int commandLineOffset = this.getCommandLineOffset();
        int commandLineLength = this.getCommandLineLength();
        if (commandLineLength < 0) {
            return "";
        }
        try {
            return this.doc.get(commandLineOffset, commandLineLength);
        }
        catch (BadLocationException badLocationException) {
            PydevPlugin.log(StringUtils.format((String)"Error: bad location: offset:%s text:%s", (Object[])new Object[]{Autobox.valueOf((int)commandLineOffset), Autobox.valueOf((int)commandLineLength)}));
            return "";
        }
    }

    public void setCommandLine(String command) throws BadLocationException {
        this.doc.replace(this.getCommandLineOffset(), this.getCommandLineLength(), command);
    }
}

