/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.IAction;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;

public class PyConvertSpaceToTab
extends PyAction {
    private PySelection ps;

    public void run(IAction action) {
        try {
            this.ps = new PySelection(this.getTextEditor());
            this.ps.selectAll(false);
            PyConvertSpaceToTab.perform(this.ps);
            this.getTextEditor().selectAndReveal(this.ps.getLineOffset(), 0);
        }
        catch (Exception e) {
            PyConvertSpaceToTab.beep(e);
        }
    }

    public static boolean perform(PySelection ps) {
        StringBuffer strbuf = new StringBuffer();
        ps.selectCompleteLine();
        try {
            int i = ps.getStartLineIndex();
            while (i <= ps.getEndLineIndex()) {
                String line = ps.getDoc().get(ps.getDoc().getLineInformation(i).getOffset(), ps.getDoc().getLineInformation(i).getLength());
                strbuf.append(String.valueOf(line.replaceAll(PyConvertSpaceToTab.getTabSpace(), "\t")) + (i < ps.getEndLineIndex() ? ps.getEndLineDelim() : ""));
                ++i;
            }
            if (strbuf.toString() != null) {
                ps.getDoc().replace(ps.getStartLine().getOffset(), ps.getSelLength(), strbuf.toString());
                return true;
            }
        }
        catch (Exception e) {
            PyConvertSpaceToTab.beep(e);
        }
        return false;
    }

    protected static String getTabSpace() {
        StringBuffer sbuf = new StringBuffer();
        int tabWidth = DefaultIndentPrefs.getStaticTabWidth();
        int i = 0;
        while (i < tabWidth) {
            sbuf.append(" ");
            ++i;
        }
        return sbuf.toString();
    }
}

