/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.REF;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;
import org.python.pydev.plugin.PydevPlugin;

public class PyOpenAction
extends Action {
    public IEditorPart editor;

    public void showInEditor(ITextEditor textEdit, Location start, Location end) {
        try {
            IDocument doc = textEdit.getDocumentProvider().getDocument((Object)textEdit.getEditorInput());
            int s = start.toOffset(doc);
            int e = end == null ? s : end.toOffset(doc);
            TextSelection sel = new TextSelection(s, e - s);
            textEdit.getSelectionProvider().setSelection((ISelection)sel);
        }
        catch (BadLocationException e1) {
            if (textEdit instanceof PyEdit) {
                PyEdit p = (PyEdit)textEdit;
                PydevPlugin.log(4, "Error setting selection:" + start + " - " + end + " - " + p.getEditorFile(), e1);
            }
            PydevPlugin.log(4, "Error setting selection:" + start + " - " + end, e1);
        }
    }

    public void run(ItemPointer p) {
        this.editor = null;
        Object file = p.file;
        String zipFilePath = p.zipFilePath;
        if (zipFilePath != null) {
            this.editor = PydevPlugin.doOpenEditor((File)file, zipFilePath, true);
        } else if (file instanceof IFile) {
            IFile f = (IFile)file;
            this.editor = PydevPlugin.doOpenEditor(f, true);
        } else if (file instanceof IPath) {
            IPath path = (IPath)file;
            this.editor = PydevPlugin.doOpenEditor(path, true);
        } else if (file instanceof File) {
            String absPath = REF.getFileAbsolutePath((File)((File)file));
            IPath path = Path.fromOSString((String)absPath);
            this.editor = PydevPlugin.doOpenEditor(path, true);
        }
        if (this.editor instanceof ITextEditor && p.start.line >= 0) {
            this.showInEditor((ITextEditor)this.editor, p.start, p.end);
        }
    }
}

