/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.docutils.PyDocIterator;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.WordUtils;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.IOrganizeImports;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;

public class PyOrganizeImports
extends PyAction {
    public void run(IAction action) {
        try {
            PySelection ps = new PySelection(this.getTextEditor());
            String endLineDelim = ps.getEndLineDelim();
            IDocument doc = ps.getDoc();
            DocumentRewriteSession session = this.startWrite(doc);
            try {
                if (ps.getStartLineIndex() == ps.getEndLineIndex()) {
                    List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_organize_imports");
                    if (participants.size() == 1) {
                        PyEdit pyEdit = this.getPyEdit();
                        ((IOrganizeImports)participants.get(0)).performArrangeImports(ps, pyEdit);
                    } else {
                        if (participants.size() > 1) {
                            PydevPlugin.log("The organize imports has more than one plugin with this extension point, therefore, the default is being used.");
                        }
                        PyOrganizeImports.performArrangeImports(doc, endLineDelim);
                    }
                } else {
                    PyOrganizeImports.performSimpleSort(doc, endLineDelim, ps.getStartLineIndex(), ps.getEndLineIndex());
                }
            }
            finally {
                this.endWrite(doc, session);
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
            PyOrganizeImports.beep(e);
        }
    }

    private void endWrite(IDocument doc, DocumentRewriteSession session) {
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 d = (IDocumentExtension4)doc;
            d.stopRewriteSession(session);
        }
    }

    private DocumentRewriteSession startWrite(IDocument doc) {
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 d = (IDocumentExtension4)doc;
            return d.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
        }
        return null;
    }

    public static void performArrangeImports(IDocument doc, String endLineDelim) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int firstImport = -1;
        PyDocIterator it = new PyDocIterator(doc, false, false, false, true);
        while (it.hasNext()) {
            String str1;
            String str = it.next();
            if (!str.startsWith("import ") && !str.startsWith("from ")) continue;
            int iToAdd = it.getLastReturnedLine();
            if (str.indexOf(40) != -1) {
                while (it.hasNext() && str.indexOf(41) == -1) {
                    str1 = it.next();
                    str = String.valueOf(str) + endLineDelim + str1;
                }
            }
            if (WordUtils.endsWith((String)str, (char)'\\')) {
                while (it.hasNext() && WordUtils.endsWith((String)str, (char)'\\')) {
                    str1 = it.next();
                    str = String.valueOf(str) + endLineDelim + str1;
                }
            }
            list.add(new Object[]{Autobox.valueOf((int)iToAdd), str});
            if (firstImport != -1) continue;
            firstImport = iToAdd;
        }
        if (firstImport == -1) {
            return;
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                Object[] c1 = (Object[])o1;
                Object[] c2 = (Object[])o2;
                Integer i1 = (Integer)c1[0];
                Integer i2 = (Integer)c2[0];
                return i2.compareTo(i1);
            }
        });
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object[] element = (Object[])iter.next();
            String s = (String)element[1];
            int i = PySelection.countLineBreaks((String)s);
            while (i >= 0) {
                PySelection.deleteLine((IDocument)doc, (int)((Integer)element[0]));
                --i;
            }
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                Object[] c1 = (Object[])o1;
                Object[] c2 = (Object[])o2;
                String s1 = (String)c1[1];
                String s2 = (String)c2[1];
                return s1.compareTo(s2);
            }
        });
        --firstImport;
        StringBuffer all = new StringBuffer();
        Iterator iter2 = list.iterator();
        while (iter2.hasNext()) {
            Object[] element = (Object[])iter2.next();
            all.append((String)element[1]);
            all.append(endLineDelim);
        }
        PySelection.addLine((IDocument)doc, (String)endLineDelim, (String)all.toString(), (int)firstImport);
    }

    public static void performSimpleSort(IDocument doc, String endLineDelim, int startLine, int endLine) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringBuffer lastLine = null;
            int i = startLine;
            while (i <= endLine) {
                String line = PySelection.getLine((IDocument)doc, (int)i);
                if (lastLine != null) {
                    int len = lastLine.length();
                    if (len > 0 && lastLine.charAt(len - 1) == '\\') {
                        lastLine.append(endLineDelim);
                        lastLine.append(line);
                    } else {
                        list.add(lastLine.toString());
                        lastLine = new StringBuffer(line);
                    }
                } else {
                    lastLine = new StringBuffer(line);
                }
                ++i;
            }
            if (lastLine != null) {
                list.add(lastLine.toString());
            }
            Collections.sort(list);
            StringBuffer all = new StringBuffer();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                all.append(element);
                if (!iter.hasNext()) continue;
                all.append(endLineDelim);
            }
            int length = doc.getLineInformation(endLine).getLength();
            int endOffset = doc.getLineInformation(endLine).getOffset() + length;
            int startOffset = doc.getLineInformation(startLine).getOffset();
            doc.replace(startOffset, endOffset - startOffset, all.toString());
        }
        catch (BadLocationException e) {
            PydevPlugin.log(e);
        }
    }
}

