/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IToken;
import org.python.pydev.core.docutils.ImportsSelection;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;
import org.python.pydev.editor.codecompletion.PyCalltipsContextInformation;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;
import org.python.pydev.editor.codecompletion.PyCompletionProposal;
import org.python.pydev.editor.codecompletion.PyLinkedModeCompletionProposal;
import org.python.pydev.editor.codecompletion.revisited.AbstractToken;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPyCodeCompletion
implements IPyCodeCompletion {
    @Override
    public ICodeCompletionASTManager.ImportInfo getImportsTipperStr(CompletionRequest request) {
        IDocument doc = request.doc;
        int documentOffset = request.documentOffset;
        return ImportsSelection.getImportsTipperStr((IDocument)doc, (int)documentOffset);
    }

    protected void changeItokenToCompletionPropostal(ITextViewer viewer, CompletionRequest request, List<ICompletionProposal> convertedProposals, List<Object> iTokenList, boolean importsTip, ICompletionState state) {
        for (Object obj : iTokenList) {
            String name;
            Object[] element;
            if (obj instanceof IToken) {
                element = (Object[])obj;
                name = element.getRepresentation();
                int l = name.length();
                String args = "";
                if (!importsTip) {
                    boolean getIt = true;
                    if (AbstractToken.isClassDef((IToken)element) && !request.isInCalltip) {
                        getIt = false;
                    }
                    if (getIt && (args = this.getArgs((IToken)element, state)).length() > 0) {
                        ++l;
                    }
                }
                if (name.equals(request.fullQualifier) && args.trim().length() == 0) continue;
                int type = element.getType();
                int priority = 10;
                if (type == 5 || type == 9 || type == 10) {
                    priority = -1;
                }
                int notInCalltip = 1;
                int onApplyAction = 1;
                if (request.isInCalltip) {
                    notInCalltip = 0;
                    onApplyAction = request.alreadyHasParams ? 2 : 3;
                }
                int replacementOffset = request.documentOffset - request.qlen;
                PyCalltipsContextInformation pyContextInformation = null;
                if (args.length() > 2) {
                    pyContextInformation = new PyCalltipsContextInformation(args, replacementOffset + name.length() + notInCalltip);
                }
                PyLinkedModeCompletionProposal proposal = new PyLinkedModeCompletionProposal(new StringBuffer(String.valueOf(name)).append(args).toString(), replacementOffset, request.qlen, l, (IToken)element, null, pyContextInformation, priority, onApplyAction, args);
                convertedProposals.add(proposal);
                continue;
            }
            if (obj instanceof Object[]) {
                element = (Object[])obj;
                name = (String)element[0];
                String docStr = (String)element[1];
                int type = -1;
                if (element.length > 2) {
                    type = (Integer)element[2];
                }
                int priority = 10;
                if (type == 5) {
                    priority = -1;
                }
                PyCompletionProposal proposal = new PyCompletionProposal(name, request.documentOffset - request.qlen, request.qlen, name.length(), PyCodeCompletionImages.getImageForType(type), null, null, docStr, priority);
                convertedProposals.add(proposal);
                continue;
            }
            if (!(obj instanceof ICompletionProposal)) continue;
            convertedProposals.add((ICompletionProposal)obj);
        }
    }

    protected String getArgs(IToken element, ICompletionState state) {
        int lookingFor = state.getLookingFor();
        return this.getArgs(element, lookingFor);
    }

    private String getArgs(IToken element, int lookingFor) {
        return AbstractPyCodeCompletion.getArgs(element.getArgs(), element.getType(), lookingFor);
    }

    public static String getArgs(String argsReceived, int type, int lookingFor) {
        boolean lookingForInstance;
        String args = "";
        boolean bl = lookingForInstance = lookingFor == 0 || lookingFor == 1 || lookingFor == 4;
        if (argsReceived.trim().length() > 0) {
            StringBuffer buffer = new StringBuffer("(");
            StringTokenizer strTok = new StringTokenizer(argsReceived, "( ,)");
            while (strTok.hasMoreTokens()) {
                String tok = strTok.nextToken();
                boolean addIt = lookingForInstance && tok.equals("self") ? false : lookingForInstance || !tok.equals("cls");
                if (!addIt) continue;
                if (buffer.length() > 1) {
                    buffer.append(", ");
                }
                buffer.append(tok);
            }
            buffer.append(")");
            args = buffer.toString();
        } else if (type == 2) {
            args = "()";
        }
        return args;
    }
}

