/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.modules;

import org.python.pydev.editor.codecompletion.revisited.AbstractToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.visitors.NodeUtils;

public class SourceToken
extends AbstractToken {
    private static final long serialVersionUID = 1L;
    private SimpleNode ast;
    int[] colLineEndToFirstDot;
    int[] colLineEndComplete;

    public SourceToken(SimpleNode node, String rep, String args, String doc, String parentPackage) {
        super(rep, doc, args, parentPackage, SourceToken.getType(node));
        this.ast = node;
    }

    public SourceToken(SimpleNode node, String rep, String args, String doc, String parentPackage, int type) {
        super(rep, doc, args, parentPackage, type);
        this.ast = node;
    }

    public SourceToken(SimpleNode node, String rep, String doc, String args, String parentPackage, String originalRep) {
        super(rep, doc, args, parentPackage, SourceToken.getType(node), originalRep);
        this.ast = node;
    }

    public static int getType(SimpleNode ast) {
        if (ast instanceof ClassDef) {
            return 1;
        }
        if (ast instanceof FunctionDef) {
            return 2;
        }
        if (ast instanceof Name) {
            return 3;
        }
        if (ast instanceof Import || ast instanceof ImportFrom) {
            return 0;
        }
        if (ast instanceof keywordType) {
            return 3;
        }
        if (ast instanceof Attribute) {
            return 3;
        }
        return -1;
    }

    public SimpleNode getAst() {
        return this.ast;
    }

    public int getLineDefinition() {
        return NodeUtils.getLineDefinition((SimpleNode)this.getRepresentationNode());
    }

    private SimpleNode getRepresentationNode() {
        if (this.ast instanceof Attribute) {
            Attribute attr = (Attribute)this.ast;
            while (attr != null) {
                String r = NodeUtils.getRepresentationString((SimpleNode)attr);
                if (r != null && r.equals(this.rep)) {
                    return attr;
                }
                if (attr.value instanceof Attribute) {
                    attr = (Attribute)attr.value;
                    continue;
                }
                r = NodeUtils.getRepresentationString((SimpleNode)attr.value);
                if (r == null || !r.equals(this.rep)) break;
                return attr.value;
            }
        }
        return this.ast;
    }

    public int getColDefinition() {
        return NodeUtils.getColDefinition((SimpleNode)this.ast);
    }

    public int getLineEnd(boolean getOnlyToFirstDot) {
        if (getOnlyToFirstDot) {
            if (this.colLineEndToFirstDot == null) {
                this.colLineEndToFirstDot = NodeUtils.getColLineEnd((SimpleNode)this.getRepresentationNode(), (boolean)getOnlyToFirstDot);
            }
            return this.colLineEndToFirstDot[0];
        }
        if (this.colLineEndComplete == null) {
            this.colLineEndComplete = NodeUtils.getColLineEnd((SimpleNode)this.getRepresentationNode(), (boolean)getOnlyToFirstDot);
        }
        return this.colLineEndComplete[0];
    }

    public int getColEnd(boolean getOnlyToFirstDot) {
        if (getOnlyToFirstDot) {
            if (this.colLineEndToFirstDot == null) {
                this.colLineEndToFirstDot = NodeUtils.getColLineEnd((SimpleNode)this.getRepresentationNode(), (boolean)getOnlyToFirstDot);
            }
            return this.colLineEndToFirstDot[1];
        }
        if (this.colLineEndComplete == null) {
            this.colLineEndComplete = NodeUtils.getColLineEnd((SimpleNode)this.getRepresentationNode(), (boolean)getOnlyToFirstDot);
        }
        return this.colLineEndComplete[1];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceToken)) {
            return false;
        }
        SourceToken s = (SourceToken)obj;
        if (!s.getRepresentation().equals(this.getRepresentation())) {
            return false;
        }
        if (s.getLineDefinition() != this.getLineDefinition()) {
            return false;
        }
        return s.getColDefinition() == this.getColDefinition();
    }

    public int hashCode() {
        return 7 * this.getLineDefinition() * this.getColDefinition();
    }

    public boolean isImport() {
        return this.ast instanceof Import || this.ast instanceof ImportFrom;
    }

    public boolean isImportFrom() {
        return this.ast instanceof ImportFrom;
    }

    public boolean isWildImport() {
        return AbstractVisitor.isWildImport(this.ast);
    }

    public boolean isString() {
        return AbstractVisitor.isString(this.ast);
    }

    public int[] getLineColEnd() {
        if (this.ast instanceof NameTok || this.ast instanceof Name) {
            return new int[]{this.getLineDefinition(), this.getColDefinition() + this.getRepresentation().length()};
        }
        throw new RuntimeException("Unable to get the lenght of the token:" + this.ast.getClass().getName());
    }
}

