/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.model;

import java.io.File;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.Location;
import org.python.pydev.parser.jython.SimpleNode;

public class ItemPointer {
    public Object file;
    public Location start;
    public Location end;
    public Definition definition;
    public String zipFilePath;

    public ItemPointer(Object file) {
        this(file, new Location(), new Location());
    }

    public ItemPointer(Object file, SimpleNode n) {
        int line = n.beginLine;
        int col = n.beginColumn;
        this.file = file;
        this.start = new Location(line - 1, col - 1);
        this.end = new Location(line - 1, col - 1);
    }

    public ItemPointer(Object file, Location start, Location end) {
        this.file = file;
        this.start = start;
        this.end = end;
    }

    public ItemPointer(File file2, Location location, Location location2, Definition definition, String zipFilePath) {
        this(file2, location, location2);
        this.definition = definition;
        this.zipFilePath = zipFilePath;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ItemPointer [");
        buffer.append(this.file);
        buffer.append(" - ");
        buffer.append(this.start);
        buffer.append(" - ");
        buffer.append(this.end);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemPointer)) {
            return false;
        }
        ItemPointer i = (ItemPointer)obj;
        if (!i.file.equals(this.file)) {
            return false;
        }
        if (!i.start.equals(this.start)) {
            return false;
        }
        return i.end.equals(this.end);
    }

    public int hashCode() {
        if (this.file != null) {
            return this.file.hashCode() * 17;
        }
        return (this.end.column + 1) * (this.start.line + 2) * 9;
    }
}

