/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.runners;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.Tuple;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleRunner;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePythonRunner
extends SimpleRunner {
    @Override
    public Tuple<String, String> runAndGetOutput(String script, String[] args, File workingDir, IProject project) {
        String[] parameters = SimplePythonRunner.addInterpreterToArgs(script, args);
        return this.runAndGetOutput(parameters, workingDir, project);
    }

    public static String makeExecutableCommandStr(String script, String[] args) {
        String[] s = SimplePythonRunner.addInterpreterToArgs(script, args);
        return SimplePythonRunner.getCommandLineAsString(s, args);
    }

    private static String[] addInterpreterToArgs(String script, String[] args) {
        String interpreter = PydevPlugin.getPythonInterpreterManager().getDefaultInterpreter();
        return SimplePythonRunner.preparePythonCallParameters(interpreter, script, args);
    }

    public Tuple<String, String> runAndGetOutputWithInterpreter(String interpreter, String script, String[] args, File workingDir, IProject project, IProgressMonitor monitor) {
        monitor.setTaskName("Mounting executable string...");
        monitor.worked(5);
        File file = new File(script);
        if (!file.exists()) {
            throw new RuntimeException(new StringBuffer("The script passed for execution (").append(script).append(") does not exist.").toString());
        }
        String[] s = SimplePythonRunner.preparePythonCallParameters(interpreter, script, args);
        monitor.worked(1);
        return this.runAndGetOutput(s, workingDir, project, monitor);
    }

    private static String[] preparePythonCallParameters(String interpreter, String script, String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        String[] s = new String[3 + args.length];
        s[0] = interpreter;
        s[1] = "-u";
        s[2] = script;
        System.arraycopy(args, 0, s, 3, args.length);
        return s;
    }
}

