/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.runners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.ThreadStreamReader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleRunner {
    public abstract Tuple<String, String> runAndGetOutput(String var1, String[] var2, File var3, IProject var4);

    public Process createProcess(String executionString, File workingDir) throws IOException {
        return Runtime.getRuntime().exec(executionString, null, workingDir);
    }

    public Process createProcess(String[] parameters, File workingDir) throws IOException {
        return Runtime.getRuntime().exec(parameters, null, workingDir);
    }

    public String[] getEnvironment(IPythonNature pythonNature, String interpreter) throws CoreException {
        if (pythonNature == null) {
            return SimpleRunner.getDefaultSystemEnvAsArray();
        }
        String pythonPathEnvStr = "";
        try {
            if (PydevPlugin.getInterpreterManager(pythonNature).hasInfoOnInterpreter(interpreter)) {
                pythonPathEnvStr = SimpleRunner.makePythonPathEnvString(pythonNature, interpreter);
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
            return null;
        }
        return SimpleRunner.createEnvWithPythonpath(pythonPathEnvStr);
    }

    public static String[] createEnvWithPythonpath(String pythonPathEnvStr) throws CoreException {
        DebugPlugin defaultPlugin = DebugPlugin.getDefault();
        if (defaultPlugin != null) {
            Map<String, String> env = SimpleRunner.getDefaultSystemEnv(defaultPlugin);
            env.put("PYTHONPATH", pythonPathEnvStr);
            return SimpleRunner.getMapEnvAsArray(env);
        }
        return null;
    }

    public static String[] getDefaultSystemEnvAsArray() throws CoreException {
        Map<String, String> defaultSystemEnv = SimpleRunner.getDefaultSystemEnv();
        if (defaultSystemEnv != null) {
            return SimpleRunner.getMapEnvAsArray(defaultSystemEnv);
        }
        return null;
    }

    public static Map<String, String> getDefaultSystemEnv() throws CoreException {
        DebugPlugin defaultPlugin = DebugPlugin.getDefault();
        return SimpleRunner.getDefaultSystemEnv(defaultPlugin);
    }

    private static Map<String, String> getDefaultSystemEnv(DebugPlugin defaultPlugin) throws CoreException {
        if (defaultPlugin != null) {
            ILaunchManager launchManager = defaultPlugin.getLaunchManager();
            HashMap<String, String> env = new HashMap<String, String>();
            env.putAll(launchManager.getNativeEnvironment());
            boolean win32 = REF.isWindowsPlatform();
            for (Map.Entry entry : env.entrySet()) {
                String value;
                String key = (String)entry.getKey();
                if (win32) {
                    key = key.toUpperCase();
                }
                String translated = value = (String)entry.getValue();
                try {
                    translated = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value, false);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                env.put(key, translated);
            }
            return env;
        }
        return null;
    }

    public static String getCommandLineAsString(String[] commandLine, String ... args) {
        if (args != null && args.length > 0) {
            String[] newCommandLine = new String[commandLine.length + args.length];
            System.arraycopy(commandLine, 0, newCommandLine, 0, commandLine.length);
            System.arraycopy(args, 0, newCommandLine, commandLine.length, args.length);
            commandLine = newCommandLine;
        }
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            if (commandLine[i] != null) {
                buf.append(' ');
                char[] characters = commandLine[i].toCharArray();
                StringBuffer command = new StringBuffer();
                boolean containsSpace = false;
                int j = 0;
                while (j < characters.length) {
                    char character = characters[j];
                    if (character == '\"') {
                        command.append('\\');
                    } else if (character == ' ') {
                        containsSpace = true;
                    }
                    command.append(character);
                    ++j;
                }
                if (containsSpace) {
                    buf.append('\"');
                    buf.append(command.toString());
                    buf.append('\"');
                } else {
                    buf.append(command.toString());
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String makePythonPathEnvString(IPythonNature pythonNature, String interpreter) {
        if (pythonNature == null) {
            return SimpleRunner.makePythonPathEnvFromPaths(new ArrayList<String>());
        }
        IPythonPathNature pythonPathNature = pythonNature.getPythonPathNature();
        if (pythonPathNature == null) {
            IProject project = pythonNature.getProject();
            String projectName = project == null ? "null?" : project.getName();
            throw new RuntimeException(new StringBuffer("The project ").append(projectName).append(" does not have the pythonpath configured, \n").append("please configure it correcly (please check the pydev faq at \n").append("http://pydev.sf.net/faq.html for better information on how to do it).").toString());
        }
        List paths = pythonPathNature.getCompleteProjectPythonPath(interpreter);
        return SimpleRunner.makePythonPathEnvFromPaths(paths);
    }

    public static String makePythonPathEnvFromPaths(Collection<String> inPaths) {
        ArrayList<String> paths = new ArrayList<String>(inPaths);
        try {
            paths.add(0, REF.getFileAbsolutePath((File)PydevPlugin.getScriptWithinPySrc("pydev_sitecustomize")));
        }
        catch (CoreException e) {
            PydevPlugin.log(e);
        }
        String separator = SimpleRunner.getPythonPathSeparator();
        StringBuffer pythonpath = new StringBuffer();
        boolean first = true;
        for (String path : paths) {
            if (first) {
                first = false;
            } else {
                pythonpath.append(separator);
            }
            pythonpath.append(path);
        }
        return pythonpath.toString();
    }

    public static String getPythonPathSeparator() {
        return System.getProperty("path.separator");
    }

    private static String[] getMapEnvAsArray(Map<String, String> env) {
        ArrayList<String> strings = new ArrayList<String>(env.size());
        for (Map.Entry<String, String> entry : env.entrySet()) {
            StringBuffer buffer = new StringBuffer(entry.getKey());
            buffer.append('=').append(entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public Tuple<String, String> runAndGetOutput(String executionString, File workingDir, IProgressMonitor monitor) {
        return this.runAndGetOutput(executionString, workingDir, null, monitor);
    }

    public Tuple<String, String> runAndGetOutput(String executionString, File workingDir) {
        return this.runAndGetOutput(executionString, workingDir, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public Tuple<String, String> runAndGetOutput(String executionString, File workingDir, IProject project) {
        return this.runAndGetOutput(executionString, workingDir, project, (IProgressMonitor)new NullProgressMonitor());
    }

    public Tuple<String, String> runAndGetOutput(String[] arguments, File workingDir, IProject project) {
        return this.runAndGetOutput(arguments, workingDir, project, (IProgressMonitor)new NullProgressMonitor());
    }

    public Tuple<String, String> runAndGetOutput(String script, String[] args, File workingDir) {
        return this.runAndGetOutput(script, args, workingDir, null);
    }

    public Tuple<String, String> runAndGetOutput(String[] arguments, File workingDir, IProject project, IProgressMonitor monitor) {
        String executionString = SimpleRunner.getCommandLineAsString(arguments, new String[0]);
        monitor.setTaskName(new StringBuffer("Executing: ").append(executionString).toString());
        monitor.worked(5);
        Process process = null;
        try {
            monitor.setTaskName(new StringBuffer("Making pythonpath environment...").append(executionString).toString());
            String[] envp = this.getEnvironment(PythonNature.getPythonNature(project), null);
            monitor.setTaskName(new StringBuffer("Making exec...").append(executionString).toString());
            if (workingDir != null && !workingDir.isDirectory()) {
                throw new RuntimeException(StringUtils.format((String)"Working dir must be an existing directory (received: %s)", (Object[])new Object[]{workingDir}));
            }
            process = Runtime.getRuntime().exec(arguments, envp, workingDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.getProcessOutput(process, executionString, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<String, String> getProcessOutput(Process process, String executionString, IProgressMonitor monitor) {
        if (process != null) {
            try {
                process.getOutputStream().close();
            }
            catch (IOException iOException) {}
            monitor.setTaskName("Reading output...");
            monitor.worked(5);
            ThreadStreamReader std = new ThreadStreamReader(process.getInputStream());
            ThreadStreamReader err = new ThreadStreamReader(process.getErrorStream());
            std.start();
            err.start();
            try {
                monitor.setTaskName("Waiting for process to finish.");
                monitor.worked(5);
                process.waitFor();
            }
            catch (InterruptedException e1) {
                throw new RuntimeException(e1);
            }
            try {
                SimpleRunner simpleRunner = this;
                synchronized (simpleRunner) {
                    this.wait(50L);
                }
            }
            catch (Exception exception) {}
            return new Tuple((Object)std.contents.toString(), (Object)err.contents.toString());
        }
        try {
            throw new CoreException((IStatus)PydevPlugin.makeStatus(4, new StringBuffer("Error creating process - got null process(").append(executionString).append(")").toString(), new Exception("Error creating process - got null process.")));
        }
        catch (CoreException e) {
            PydevPlugin.log(4, e.getMessage(), e);
            return new Tuple((Object)"", (Object)new StringBuffer("Error creating process - got null process(").append(executionString).append(")").toString());
        }
    }

    public Tuple<String, String> runAndGetOutput(String executionString, File workingDir, IProject project, IProgressMonitor monitor) {
        monitor.setTaskName(new StringBuffer("Executing: ").append(executionString).toString());
        monitor.worked(5);
        Process process = null;
        try {
            monitor.setTaskName(new StringBuffer("Making pythonpath environment...").append(executionString).toString());
            String[] envp = this.getEnvironment(PythonNature.getPythonNature(project), null);
            monitor.setTaskName(new StringBuffer("Making exec...").append(executionString).toString());
            if (workingDir != null && !workingDir.isDirectory()) {
                throw new RuntimeException(StringUtils.format((String)"Working dir must be an existing directory (received: %s)", (Object[])new Object[]{workingDir}));
            }
            process = Runtime.getRuntime().exec(executionString, envp, workingDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.getProcessOutput(process, executionString, monitor);
    }

    public static List<String> splitPythonpath(String pythonpath) {
        ArrayList<String> splitted = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(pythonpath, SimpleRunner.getPythonPathSeparator());
        while (tokenizer.hasMoreTokens()) {
            splitted.add(tokenizer.nextToken());
        }
        return splitted;
    }
}

