/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.WordUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyDocIterator
implements Iterator<String> {
    private int offset;
    private IDocument doc;
    private boolean addNewLinesToRet = true;
    private boolean returnNewLinesOnLiterals = false;
    private boolean inLiteral = false;
    private int literalEnd = 0;
    private boolean changeLiteralsForSpaces = false;
    private int lastReturned = -1;
    private boolean addComments = false;

    public PyDocIterator(IDocument doc, boolean addNewLinesToRet) {
        this(doc, addNewLinesToRet, false, false);
    }

    public PyDocIterator(IDocument doc, boolean addNewLinesToRet, boolean returnNewLinesOnLiterals, boolean changeLiteralsForSpaces) {
        this(doc, addNewLinesToRet, returnNewLinesOnLiterals, changeLiteralsForSpaces, false);
    }

    public PyDocIterator(IDocument doc, boolean addNewLinesToRet, boolean returnNewLinesOnLiterals, boolean changeLiteralsForSpaces, boolean addComments) {
        this(doc);
        this.addNewLinesToRet = addNewLinesToRet;
        this.returnNewLinesOnLiterals = returnNewLinesOnLiterals;
        this.changeLiteralsForSpaces = changeLiteralsForSpaces;
        this.addComments = addComments;
    }

    public PyDocIterator(IDocument doc) {
        this.doc = doc;
    }

    public void setStartingOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public boolean hasNext() {
        return this.offset < this.doc.getLength();
    }

    public int getLastReturnedLine() {
        try {
            this.lastReturned = this.doc.getLineOfOffset(this.offset - 1);
        }
        catch (BadLocationException badLocationException) {}
        return this.lastReturned;
    }

    private String nextInLiteral() {
        StringBuffer buf = new StringBuffer();
        try {
            int ch = this.doc.getChar(this.offset);
            while (this.offset < this.literalEnd && ch != 10 && ch != 13) {
                ch = this.doc.getChar(this.offset);
                ++this.offset;
                if (!this.changeLiteralsForSpaces || ch == 10 || ch == 13) continue;
                buf.append(' ');
            }
            if (this.offset >= this.literalEnd) {
                this.inLiteral = false;
                ++this.offset;
                if (this.changeLiteralsForSpaces) {
                    buf.append(' ');
                }
                return buf.toString();
            }
            if (ch == 13 && (ch = this.doc.getChar(this.offset + 1)) == 10) {
                ++this.offset;
                ch = 10;
            }
            buf.append((char)ch);
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String next() {
        try {
            String ret;
            StringBuffer buf = new StringBuffer();
            if (this.inLiteral) {
                int initialOffset = this.offset;
                ret = this.nextInLiteral();
                if (ret.length() > 0 && initialOffset < this.offset) {
                    if (WordUtils.endsWith(ret, '\r') || WordUtils.endsWith(ret, '\n')) {
                        if (!this.addNewLinesToRet) {
                            ret = ret.substring(0, ret.length() - 1);
                        }
                        buf.append(ret);
                        return ret;
                    }
                    buf.append(ret);
                }
            }
            char ch = '\u0000';
            while (ch != '\r' && ch != '\n' && this.offset < this.doc.getLength()) {
                ch = this.doc.getChar(this.offset);
                if (ch == '#') {
                    while (this.offset < this.doc.getLength() && ch != '\n' && ch != '\r') {
                        ch = this.doc.getChar(this.offset);
                        if (this.addComments && ch != '\n' && ch != '\r') {
                            buf.append(ch);
                        }
                        ++this.offset;
                    }
                    continue;
                }
                if (ch == '\'' || ch == '\"') {
                    if (this.returnNewLinesOnLiterals) {
                        this.inLiteral = true;
                        this.literalEnd = ParsingUtils.getLiteralEnd(this.doc, this.offset, ch);
                        ret = this.nextInLiteral();
                        if (ret.length() <= 0) continue;
                        if (WordUtils.endsWith(ret, '\r') || WordUtils.endsWith(ret, '\n')) {
                            if (!this.addNewLinesToRet) {
                                ret = ret.substring(0, ret.length() - 1);
                            }
                            buf.append(ret);
                            return buf.toString();
                        }
                        buf.append(ret);
                        continue;
                    }
                    if (this.changeLiteralsForSpaces) {
                        throw new RuntimeException("Not supported in this case.");
                    }
                    this.offset = ParsingUtils.getLiteralEnd(this.doc, this.offset, ch);
                    ++this.offset;
                    continue;
                }
                if (ch != '\n' && ch != '\r') {
                    buf.append(ch);
                    ++this.offset;
                    continue;
                }
                ++this.offset;
            }
            if (ch == '\n' || ch == '\r') {
                if (this.addNewLinesToRet) {
                    buf.append(ch);
                }
                if (ch == '\r' && this.offset < this.doc.getLength() && this.doc.getChar(this.offset) == '\n') {
                    ++this.offset;
                    if (this.addNewLinesToRet) {
                        buf.append('\n');
                    }
                }
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not Impl.");
    }

    @Override
    public /* synthetic */ Object next() {
        return this.next();
    }
}

