/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import com.rc.retroweaver.runtime.ClassLiteral;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.StepCommand;
import org.python.pydev.debug.model.remote.ThreadRunCommand;
import org.python.pydev.debug.model.remote.ThreadSuspendCommand;
import org.python.pydev.plugin.PydevPlugin;

public class PyThread
extends PlatformObject
implements IThread {
    private AbstractDebugTarget target;
    private String name;
    private String id;
    private boolean isPydevThread;
    private boolean isSuspended = false;
    private boolean isStepping = false;
    private IStackFrame[] stack;

    public PyThread(AbstractDebugTarget target, String name, String id) {
        this.target = target;
        this.name = name;
        this.id = id;
        this.isPydevThread = id.equals("-1");
    }

    public void setSuspended(boolean state, IStackFrame[] stack) {
        this.isSuspended = state;
        this.stack = stack;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isPydevThread() {
        return this.isPydevThread;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public String getModelIdentifier() {
        return this.target.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.target.getLaunch();
    }

    public boolean canTerminate() {
        return !this.isPydevThread;
    }

    public boolean isTerminated() {
        return this.target.isTerminated();
    }

    public void terminate() throws DebugException {
        this.target.terminate();
    }

    public boolean canResume() {
        return !this.isPydevThread && this.isSuspended;
    }

    public boolean canSuspend() {
        return !this.isPydevThread && !this.isSuspended;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void resume() throws DebugException {
        if (!this.isPydevThread) {
            this.stack = null;
            this.isStepping = false;
            AbstractRemoteDebugger d = this.target.getDebugger();
            if (d != null) {
                d.postCommand(new ThreadRunCommand(d, this.id));
            } else {
                PydevPlugin.log((String)"Terminating: No debugger in target when resuming.");
                this.terminate();
            }
        }
    }

    public void suspend() throws DebugException {
        if (!this.isPydevThread) {
            this.stack = null;
            AbstractRemoteDebugger d = this.target.getDebugger();
            d.postCommand(new ThreadSuspendCommand(d, this.id));
        }
    }

    public boolean canStepInto() {
        return !this.isPydevThread && this.isSuspended;
    }

    public boolean canStepOver() {
        return !this.isPydevThread && this.isSuspended;
    }

    public boolean canStepReturn() {
        return !this.isPydevThread && this.isSuspended;
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void stepInto() throws DebugException {
        if (!this.isPydevThread) {
            this.isStepping = true;
            AbstractRemoteDebugger d = this.target.getDebugger();
            d.postCommand(new StepCommand(d, 107, this.id));
        }
    }

    public void stepOver() throws DebugException {
        if (!this.isPydevThread) {
            this.isStepping = true;
            AbstractRemoteDebugger d = this.target.getDebugger();
            d.postCommand(new StepCommand(d, 108, this.id));
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.isPydevThread) {
            this.isStepping = true;
            AbstractRemoteDebugger d = this.target.getDebugger();
            d.postCommand(new StepCommand(d, 109, this.id));
        }
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended && this.stack != null) {
            return this.stack;
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.stack != null && this.stack.length > 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return this.stack == null ? null : this.stack[0];
    }

    public PyStackFrame findStackFrameByID(String id) {
        if (this.stack != null) {
            int i = 0;
            while (i < this.stack.length) {
                if (id.equals(((PyStackFrame)this.stack[i]).getId())) {
                    return (PyStackFrame)this.stack[i];
                }
                ++i;
            }
        }
        return null;
    }

    public IBreakpoint[] getBreakpoints() {
        PyBreakpoint[] breaks = new PyBreakpoint[]{};
        return breaks;
    }

    public Object getAdapter(Class adapter) {
        AdapterDebug.print((Object)this, adapter);
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/core/ILaunch")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"))) {
            return this.target.getAdapter(adapter);
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/tasklist/ITaskListResourceAdapter"))) {
            return null;
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/properties/IPropertySource")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/tasklist/ITaskListResourceAdapter")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/ui/actions/IToggleBreakpointsTarget")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/ui/actions/IRunToLineTarget")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/IContributorResourceAdapter")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/model/IWorkbenchAdapter")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/IActionFilter"))) {
            return super.getAdapter(adapter);
        }
        AdapterDebug.printDontKnow((Object)this, adapter);
        return super.getAdapter(adapter);
    }
}

