/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IProcess;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.ListenConnector;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;

public class RemoteDebugger
extends AbstractRemoteDebugger {
    private ListenConnector connector;
    private Thread connectThread;
    private PythonRunnerConfig config;

    public RemoteDebugger(PythonRunnerConfig config) {
        this.config = config;
    }

    public void startConnect(IProgressMonitor monitor) throws IOException, CoreException {
        monitor.subTask("Finding free socket...");
        this.connector = new ListenConnector(this.config.getDebugPort(), this.config.acceptTimeout);
        this.connectThread = new Thread((Runnable)this.connector, "pydevd.connect");
        this.connectThread.start();
    }

    public boolean waitForConnect(IProgressMonitor monitor, Process p, IProcess ip) throws Exception {
        while (this.connectThread.isAlive()) {
            if (monitor.isCanceled()) {
                this.connector.stopListening();
                p.destroy();
                return true;
            }
            try {
                p.exitValue();
                this.connector.stopListening();
                String errorMessage = ip.getStreamsProxy().getErrorStreamMonitor().getContents();
                if (errorMessage.length() != 0) {
                    throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Something got printed in the error stream", null));
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.connector.getException() != null) {
            throw this.connector.getException();
        }
        this.connected(this.connector.getSocket());
        return false;
    }

    private void connected(Socket socket) throws IOException {
        this.socket = socket;
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (Exception exception) {}
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception exception) {}
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        this.socket = null;
        if (this.target != null) {
            this.target.debuggerDisconnected();
        }
    }

    public void dispose() {
        if (this.connector != null) {
            this.connector.stopListening();
            this.connector = null;
        }
        if (this.writer != null) {
            this.writer.done();
            this.writer = null;
        }
        if (this.reader != null) {
            this.reader.done();
            this.reader = null;
        }
        try {
            if (this.target != null) {
                this.target.terminate();
            }
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
        this.target = null;
    }
}

