/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.env;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple3;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.env.ChooseProcessTypeDialog;
import org.python.pydev.debug.newconsole.env.PydevSpawnedInterpreterProcess;
import org.python.pydev.debug.newconsole.env.UserCanceledException;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.SocketUtil;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.runners.SimpleRunner;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IProcessFactory {
    private List<IPythonNature> naturesUsed;
    public static final String INTERACTIVE_LAUNCH_PORT = "INTERACTIVE_LAUNCH_PORT";

    public List<IPythonNature> getNaturesUsed() {
        return this.naturesUsed;
    }

    public Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public Tuple3<Launch, Process, Integer> createInteractiveLaunch() throws UserCanceledException, Exception {
        ChooseProcessTypeDialog dialog;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = workbenchWindow.getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        PyEdit edit = null;
        Process process = null;
        if (activeEditor instanceof PyEdit) {
            edit = (PyEdit)activeEditor;
        }
        if ((dialog = new ChooseProcessTypeDialog(this.getShell(), edit)).open() == 0) {
            Collection<String> pythonpath = dialog.getPythonpath();
            IInterpreterManager interpreterManager = dialog.getInterpreterManager();
            if (pythonpath != null && interpreterManager != null) {
                String[] commandLine;
                this.naturesUsed = dialog.getNatures();
                int port = SocketUtil.findUnusedLocalPort();
                int clientPort = SocketUtil.findUnusedLocalPort();
                Launch launch = new Launch(null, "interactive", null);
                launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
                launch.setAttribute(INTERACTIVE_LAUNCH_PORT, new StringBuffer().append(port).toString());
                String pythonpathEnv = SimpleRunner.makePythonPathEnvFromPaths(pythonpath);
                String[] env = SimpleRunner.createEnvWithPythonpath((String)pythonpathEnv);
                File scriptWithinPySrc = PydevPlugin.getScriptWithinPySrc((String)"pydevconsole.py");
                if (interpreterManager.isPython()) {
                    commandLine = SimplePythonRunner.makeExecutableCommandStr((String)scriptWithinPySrc.getAbsolutePath(), (String[])new String[]{String.valueOf(port), String.valueOf(clientPort)});
                } else if (interpreterManager.isJython()) {
                    String vmArgs = PydevDebugPlugin.getDefault().getPreferenceStore().getString("INTERACTIVE_CONSOLE_VM_ARGS");
                    commandLine = SimpleJythonRunner.makeExecutableCommandStrWithVMArgs((String)scriptWithinPySrc.getAbsolutePath(), (String)pythonpathEnv, (String)vmArgs, (String[])new String[]{String.valueOf(port), String.valueOf(clientPort)});
                } else {
                    throw new RuntimeException("Expected interpreter manager to be python or jython related.");
                }
                process = Runtime.getRuntime().exec(commandLine, env, null);
                PydevSpawnedInterpreterProcess spawnedInterpreterProcess = new PydevSpawnedInterpreterProcess(process, (ILaunch)launch);
                launch.addProcess((IProcess)spawnedInterpreterProcess);
                return new Tuple3((Object)launch, (Object)process, (Object)Autobox.valueOf((int)clientPort));
            }
        }
        return null;
    }
}

