/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.pyunit.ITestRunListener;

public class PythonTestActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IFile selectedFile;
    private IWorkbenchPart part;

    public void run(IAction action) {
        if (this.part != null && this.selectedFile != null) {
            try {
                IPath fullPath = this.selectedFile.getLocation();
                int segmentCount = fullPath.segmentCount();
                IPath noextPath = fullPath.removeFileExtension();
                String moduleName = noextPath.lastSegment();
                IPath modulePath = fullPath.uptoSegment(segmentCount - 1);
                String moduleDir = modulePath.toString();
                IProject selectedProject = this.selectedFile.getProject();
                Listener listener = new Listener();
                PydevPlugin.getDefault().addTestListener((ITestRunListener)listener);
                try {
                    PydevPlugin.getDefault().runTests(moduleDir, moduleName, selectedProject);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                PydevPlugin.getDefault().removeTestListener((ITestRunListener)listener);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object selectedResource;
        this.selectedFile = null;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (selectedResource = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.selectedFile = (IFile)selectedResource;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public static class Listener
    implements ITestRunListener {
        private boolean passed = true;

        public void testsStarted(int testCount) {
            System.out.println("STARTING TEST RUN: " + String.valueOf(testCount) + " tests");
        }

        public void testsFinished() {
            String message = this.passed ? "PASS" : "FAIL";
            System.out.println("END TEST RUN");
            String messageLong = "TEST RUN STATUS: " + message;
            System.out.println(messageLong);
        }

        public void testStarted(String klass, String method) {
        }

        public void testFailed(String klass, String method, String trace) {
            System.out.println("TEST FAILED!");
            System.out.println(String.valueOf(klass) + " " + method);
            System.out.println(trace);
            this.passed = false;
        }
    }
}

