/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import com.rc.retroweaver.runtime.Autobox;
import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.cache.Cache;
import org.python.pydev.core.cache.LRUCache;
import org.python.pydev.core.docutils.NoPeerAvailableException;

public class DocUtils {
    public static final String EMPTY_STRING = "";
    private static Cache<Integer, String> widthToSpaceString = new LRUCache<Integer, String>(8);
    public static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};

    public static String getDocToParseFromLine(IDocument doc, int lineOfOffset) {
        String wholeDoc = doc.get();
        String newDoc = EMPTY_STRING;
        try {
            IRegion lineInformation = doc.getLineInformation(lineOfOffset);
            int docLength = doc.getLength();
            String before = wholeDoc.substring(0, lineInformation.getOffset());
            String after = wholeDoc.substring(lineInformation.getOffset() + lineInformation.getLength(), docLength);
            String src = doc.get(lineInformation.getOffset(), lineInformation.getLength());
            String spaces = EMPTY_STRING;
            int i = 0;
            while (i < src.length()) {
                if (src.charAt(i) == ' ') {
                    spaces = String.valueOf(spaces) + ' ';
                } else {
                    if (src.charAt(i) != '\t') break;
                    spaces = String.valueOf(spaces) + '\t';
                }
                ++i;
            }
            if ((src = src.trim()).startsWith("class")) {
                StringTokenizer tokenizer = new StringTokenizer(after, "\r\n");
                String tokSpaces = null;
                block3: while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken();
                    String t = tok.trim();
                    if (!t.startsWith("class") && !t.startsWith("def")) continue;
                    tokSpaces = EMPTY_STRING;
                    int i2 = 0;
                    while (i2 < tok.length()) {
                        if (tok.charAt(i2) == ' ') {
                            tokSpaces = String.valueOf(tokSpaces) + ' ';
                        } else {
                            if (tok.charAt(i2) != '\t') break block3;
                            tokSpaces = String.valueOf(tokSpaces) + '\t';
                        }
                        ++i2;
                    }
                    break block3;
                }
                src = tokSpaces != null && tokSpaces.length() > spaces.length() ? (src.indexOf(40) != -1 ? String.valueOf(src.substring(0, src.indexOf(40))) + Character.toString(':') : "class COMPLETION_HELPER_CLASS:") : (src.indexOf(40) != -1 ? String.valueOf(src.substring(0, src.indexOf(40))) + ":pass" : "class COMPLETION_HELPER_CLASS:pass");
            } else {
                src = "pass";
            }
            newDoc = before;
            newDoc = String.valueOf(newDoc) + spaces + src;
            newDoc = String.valueOf(newDoc) + after;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return newDoc;
    }

    public static String createSpaceString(int width) {
        String existing = widthToSpaceString.getObj(Autobox.valueOf((int)width));
        if (existing != null) {
            return existing;
        }
        StringBuffer b = new StringBuffer(width);
        while (width-- > 0) {
            b.append(' ');
        }
        String newStr = b.toString();
        widthToSpaceString.add(Autobox.valueOf((int)width), newStr);
        return newStr;
    }

    public static char getPeer(char c) {
        int i = 0;
        while (i < BRACKETS.length) {
            if (c == BRACKETS[i]) {
                int mod = i % 2;
                if (mod == 0) {
                    return BRACKETS[i + 1];
                }
                return BRACKETS[i - 1];
            }
            ++i;
        }
        throw new NoPeerAvailableException("Unable to find peer for :" + c);
    }

    public static boolean isClosingPeer(char lastChar) {
        return lastChar == '}' || lastChar == ')' || lastChar == ']';
    }

    public static boolean hasOpeningBracket(String trimmedLine) {
        return trimmedLine.indexOf(123) != -1 || trimmedLine.indexOf(40) != -1 || trimmedLine.indexOf(91) != -1;
    }

    public static boolean hasClosingBracket(String trimmedLine) {
        return trimmedLine.indexOf(125) != -1 || trimmedLine.indexOf(41) != -1 || trimmedLine.indexOf(93) != -1;
    }

    public static boolean isWord(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

