/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.PyDevDeltaCounter;
import org.python.pydev.builder.PydevGrouperVisitor;
import org.python.pydev.builder.pycremover.PycRemoverBuilderVisitor;
import org.python.pydev.builder.pylint.PyLintVisitor;
import org.python.pydev.builder.todo.PyTodoVisitor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.PyCodeCompletionVisitor;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.utils.PyFileListing;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyDevBuilder
extends IncrementalProjectBuilder {
    private static final boolean DEBUG = false;

    public List<PyDevBuilderVisitor> getVisitors() {
        ArrayList<PyDevBuilderVisitor> list = new ArrayList<PyDevBuilderVisitor>();
        list.add(new PyTodoVisitor());
        list.add(new PyLintVisitor());
        list.add(new PyCodeCompletionVisitor());
        list.add(new PycRemoverBuilderVisitor());
        list.addAll(ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_builder"));
        return list;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!PyDevBuilderPrefPage.usePydevBuilders()) {
            return null;
        }
        if (kind == 6) {
            this.performFullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.performFullBuild(monitor);
            } else {
                PyDevDeltaCounter counterVisitor = new PyDevDeltaCounter();
                delta.accept((IResourceDeltaVisitor)counterVisitor);
                List<PyDevBuilderVisitor> visitors = this.getVisitors();
                Collections.sort(visitors);
                PydevGrouperVisitor grouperVisitor = new PydevGrouperVisitor(visitors, monitor, counterVisitor.getNVisited());
                this.notifyVisitingWillStart(visitors, monitor, false, null);
                delta.accept((IResourceDeltaVisitor)grouperVisitor);
                this.notifyVisitingEnded(visitors, monitor);
            }
        }
        return null;
    }

    private void performFullBuild(IProgressMonitor monitor) throws CoreException {
        PythonNature nature;
        IProject project = this.getProject();
        if (project != null && (nature = PythonNature.getPythonNature(project)) != null && nature.startRequests()) {
            try {
                IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                pythonPathNature.getProjectSourcePath();
                ArrayList<IFile> resourcesToParse = new ArrayList<IFile>();
                List<PyDevBuilderVisitor> visitors = this.getVisitors();
                this.notifyVisitingWillStart(visitors, monitor, true, nature);
                monitor.beginTask("Building...", visitors.size() * 100 + 30);
                IResource[] members = project.members();
                if (members != null) {
                    int i = 0;
                    while (i < members.length) {
                        try {
                            IResource member = members[i];
                            if (member != null) {
                                if (member.getType() == 1) {
                                    this.addToResourcesToParse(resourcesToParse, (IFile)member, nature);
                                } else if (member.getType() == 2) {
                                    List<IFile> l = PyFileListing.getAllIFilesBelow((IFolder)member);
                                    for (IFile element : l) {
                                        if (element == null) continue;
                                        this.addToResourcesToParse(resourcesToParse, element, nature);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                    monitor.worked(30);
                    this.buildResources(resourcesToParse, monitor, visitors);
                }
                this.notifyVisitingEnded(visitors, monitor);
            }
            finally {
                nature.endRequests();
            }
        }
        monitor.done();
    }

    private void notifyVisitingWillStart(List<PyDevBuilderVisitor> visitors, IProgressMonitor monitor, boolean isFullBuild, IPythonNature nature) {
        for (PyDevBuilderVisitor visitor : visitors) {
            visitor.visitingWillStart(monitor, isFullBuild, nature);
        }
    }

    private void notifyVisitingEnded(List<PyDevBuilderVisitor> visitors, IProgressMonitor monitor) {
        for (PyDevBuilderVisitor visitor : visitors) {
            visitor.visitingEnded(monitor);
        }
    }

    private void addToResourcesToParse(List<IFile> resourcesToParse, IFile member, IPythonNature nature) {
        String fileExtension = member.getFileExtension();
        if (fileExtension != null && PythonPathHelper.isValidSourceFile(new StringBuffer(".").append(fileExtension).toString())) {
            resourcesToParse.add(member);
        }
    }

    public void buildResources(List<IFile> resourcesToParse, IProgressMonitor monitor, List visitors) {
        double inc = (double)(visitors.size() * 100) / (double)resourcesToParse.size();
        double total = 0.0;
        int totalResources = resourcesToParse.size();
        int i = 0;
        FastStringBuffer bufferToCreateString = new FastStringBuffer();
        Iterator<IFile> iter = resourcesToParse.iterator();
        while (iter.hasNext() && !monitor.isCanceled()) {
            ++i;
            total += inc;
            IFile r = iter.next();
            PythonNature nature = PythonNature.getPythonNature((IResource)r);
            if (nature == null || !nature.startRequests()) continue;
            try {
                if (!nature.isResourceInPythonpath((IResource)r)) continue;
                IDocument doc = REF.getDocFromResource((IResource)r);
                HashMap<String, Boolean> memo = new HashMap<String, Boolean>();
                memo.put("IS_FULL_BUILD", Autobox.valueOf((boolean)true));
                if (doc == null) continue;
                Iterator it = visitors.iterator();
                while (it.hasNext() && !monitor.isCanceled()) {
                    PyDevBuilderVisitor visitor = (PyDevBuilderVisitor)it.next();
                    visitor.memo = memo;
                    PyDevBuilder.communicateProgress(monitor, totalResources, i, (IResource)r, visitor, bufferToCreateString);
                    visitor.visitAddedResource((IResource)r, doc, monitor);
                }
                if (!(total > 1.0)) continue;
                monitor.worked((int)total);
                total -= (double)((int)total);
            }
            finally {
                nature.endRequests();
            }
        }
    }

    public static void communicateProgress(IProgressMonitor monitor, int totalResources, int i, IResource r, PyDevBuilderVisitor visitor, FastStringBuffer bufferToCreateString) {
        if (monitor != null) {
            bufferToCreateString.clear();
            bufferToCreateString.append("Pydev: Analyzing ");
            bufferToCreateString.append(i);
            bufferToCreateString.append(" of ");
            bufferToCreateString.append(totalResources);
            bufferToCreateString.append(" (");
            bufferToCreateString.append(r.getName());
            bufferToCreateString.append(")");
            String name = bufferToCreateString.toString();
            monitor.subTask(name);
        }
    }
}

