/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.todo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.PydevMarkerUtils;
import org.python.pydev.builder.todo.PyTodoPrefPage;
import org.python.pydev.plugin.PydevPlugin;

public class PyTodoVisitor
extends PyDevBuilderVisitor {
    public void visitChangedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        List<String> todoTags;
        if (document != null && (todoTags = PyTodoPrefPage.getTodoTags()).size() > 0) {
            int numberOfLines = document.getNumberOfLines();
            try {
                ArrayList<PydevMarkerUtils.MarkerInfo> lst = new ArrayList<PydevMarkerUtils.MarkerInfo>();
                int line = 0;
                while (line < numberOfLines) {
                    IRegion region = document.getLineInformation(line);
                    String tok = document.get(region.getOffset(), region.getLength());
                    Iterator<String> iterator = todoTags.iterator();
                    while (iterator.hasNext()) {
                        String element = iterator.next();
                        int index = tok.indexOf(element);
                        if (index == -1) continue;
                        String message = tok.substring(index).trim();
                        String markerType = "org.eclipse.core.resources.taskmarker";
                        int severity = 1;
                        boolean userEditable = false;
                        boolean isTransient = false;
                        int absoluteStart = region.getOffset() + index;
                        int absoluteEnd = absoluteStart + message.length();
                        Map<String, Object> additionalInfo = null;
                        PydevMarkerUtils.MarkerInfo markerInfo = new PydevMarkerUtils.MarkerInfo(document, message, markerType, severity, userEditable, isTransient, line, absoluteStart, absoluteEnd, additionalInfo);
                        lst.add(markerInfo);
                    }
                    ++line;
                }
                PydevMarkerUtils.replaceMarkers(lst, resource, "org.eclipse.core.resources.taskmarker");
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
    }

    public void visitRemovedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
    }
}

