/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingService;
import org.python.pydev.plugin.PydevPlugin;

public class PyReconciler
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ISourceViewer fViewer;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private SpellingService fSpellingService;
    private ISpellingProblemCollector fSpellingProblemCollector;
    private SpellingContext fSpellingContext;

    public PyReconciler(ISourceViewer viewer, SpellingService spellingService) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)spellingService);
        this.fViewer = viewer;
        this.fSpellingService = spellingService;
        this.fSpellingContext = new SpellingContext();
        this.fSpellingContext.setContentType(this.getContentType());
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion region) {
        if (this.fViewer.getAnnotationModel() == null || this.fSpellingProblemCollector == null) {
            return;
        }
        try {
            ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)this.fDocument, (String)"__PYTHON_PARTITION_TYPE", (int)0, (int)this.fDocument.getLength(), (boolean)false);
            ArrayList<Region> regions = new ArrayList<Region>();
            ITypedRegion[] iTypedRegionArray = partitions;
            int n = partitions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion partition = iTypedRegionArray[n2];
                if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                    return;
                }
                String type = partition.getType();
                if (!type.equals("__dftl_partition_content_type") && !type.equals("__python_backquotes")) {
                    regions.add(new Region(partition.getOffset(), partition.getLength()));
                }
                ++n2;
            }
            int size = regions.size();
            if (size > 0) {
                this.fSpellingService.check(this.fDocument, regions.toArray(new IRegion[size]), this.fSpellingContext, this.fSpellingProblemCollector, this.fProgressMonitor);
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
    }

    protected IContentType getContentType() {
        return Platform.getContentTypeManager().getContentType("org.python.pydev.pythonfile");
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        IAnnotationModel model = this.fViewer.getAnnotationModel();
        this.fSpellingProblemCollector = model == null ? null : new SpellingProblemCollector(model);
    }

    public final void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private IAnnotationModel fAnnotationModel;
        private Map fAddAnnotations;
        private Object fLockObject;

        public SpellingProblemCollector(IAnnotationModel annotationModel) {
            Assert.isLegal((annotationModel != null ? 1 : 0) != 0);
            this.fAnnotationModel = annotationModel;
            this.fLockObject = this.fAnnotationModel instanceof ISynchronizable ? ((ISynchronizable)this.fAnnotationModel).getLockObject() : this.fAnnotationModel;
        }

        public void accept(SpellingProblem problem) {
            this.fAddAnnotations.put(new SpellingAnnotation(problem), new Position(problem.getOffset(), problem.getLength()));
        }

        public void beginCollecting() {
            this.fAddAnnotations = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endCollecting() {
            ArrayList toRemove = new ArrayList();
            Object object = this.fLockObject;
            synchronized (object) {
                Iterator iter = this.fAnnotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Object n = iter.next();
                    if (!(n instanceof SpellingAnnotation)) continue;
                    toRemove.add(n);
                }
                Annotation[] annotationsToRemove = toRemove.toArray(new Annotation[toRemove.size()]);
                if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(annotationsToRemove, this.fAddAnnotations);
                } else {
                    int i = 0;
                    while (i < annotationsToRemove.length) {
                        this.fAnnotationModel.removeAnnotation(annotationsToRemove[i]);
                        ++i;
                    }
                    iter = this.fAddAnnotations.keySet().iterator();
                    while (iter.hasNext()) {
                        Annotation annotation = (Annotation)iter.next();
                        this.fAnnotationModel.addAnnotation(annotation, (Position)this.fAddAnnotations.get(annotation));
                    }
                }
            }
            this.fAddAnnotations = null;
        }
    }
}

