/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import com.rc.retroweaver.runtime.Autobox;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.actions.PyAction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyComment
extends PyAction {
    public void run(IAction action) {
        try {
            PySelection ps = new PySelection(this.getTextEditor());
            Tuple<Integer, Integer> repRegion = this.perform(ps);
            this.getTextEditor().selectAndReveal(((Integer)repRegion.o1).intValue(), ((Integer)repRegion.o2).intValue());
        }
        catch (Exception e) {
            PyComment.beep(e);
        }
    }

    public Tuple<Integer, Integer> perform(PySelection ps) throws BadLocationException {
        ps.selectCompleteLine();
        String selectedText = ps.getSelectedText();
        List ret = StringUtils.splitInLines((String)selectedText);
        FastStringBuffer strbuf = new FastStringBuffer(selectedText.length() + ret.size() + 2);
        for (String line : ret) {
            strbuf.append('#');
            strbuf.append(line);
        }
        ITextSelection txtSel = ps.getTextSelection();
        int start = txtSel.getOffset();
        int len = txtSel.getLength();
        String replacement = strbuf.toString();
        ps.getDoc().replace(start, len, replacement);
        return new Tuple((Object)Autobox.valueOf((int)start), (Object)Autobox.valueOf((int)replacement.length()));
    }
}

