/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.visitors;

import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IToken;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.parser.jython.SimpleNode;

public class Definition
implements IDefinition {
    public int line;
    public int col;
    public String value;
    public IModule module;
    public SimpleNode ast;
    public ILocalScope scope;
    public boolean foundAsLocal;

    public Definition(int line, int col, String value, SimpleNode ast, ILocalScope scope, IModule module) {
        this(line, col, value, ast, scope, module, false);
    }

    public Definition(int line, int col, String value, SimpleNode ast, ILocalScope scope, IModule module, boolean foundAsLocal) {
        Assert.isNotNull((Object)value, (String)"Invalid value.");
        Assert.isNotNull((Object)module, (String)"Invalid Module.");
        this.line = line;
        this.col = col;
        this.value = value;
        this.ast = ast;
        this.scope = scope;
        this.module = module;
        this.foundAsLocal = foundAsLocal;
    }

    public Definition(IToken tok, ILocalScope scope, IModule module) {
        this(tok, scope, module, false);
    }

    public Definition(IToken tok, ILocalScope scope, IModule module, boolean foundAsLocal) {
        Assert.isNotNull((Object)tok, (String)"Invalid value.");
        Assert.isNotNull((Object)module, (String)"Invalid Module.");
        this.line = tok.getLineDefinition();
        this.col = tok.getColDefinition();
        this.value = tok.getRepresentation();
        if (tok instanceof SourceToken) {
            this.ast = ((SourceToken)tok).getAst();
        }
        this.scope = scope;
        this.module = module;
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer("Definition=", 30 + this.value.length());
        buffer.append(this.value);
        buffer.append(" line=");
        buffer.append(this.line);
        buffer.append(" col=");
        buffer.append(this.col);
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Definition)) {
            return false;
        }
        Definition d = (Definition)obj;
        if (!this.value.equals(d.value)) {
            return false;
        }
        if (this.col != d.col) {
            return false;
        }
        if (this.line != d.line) {
            return false;
        }
        if (this.scope == d.scope) {
            return true;
        }
        if (this.scope == null || d.scope == null) {
            return false;
        }
        return this.scope.equals(d.scope);
    }

    public int hashCode() {
        return this.value.hashCode() + this.col + this.line;
    }
}

