/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.visitors;

import java.util.Stack;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;

public class HeuristicFindAttrs
extends AbstractVisitor {
    private boolean discoverSelfAttrs = true;
    public Stack<SimpleNode> stack = new Stack();
    public static final int WHITIN_METHOD_CALL = 0;
    public static final int WHITIN_INIT = 1;
    public static final int WHITIN_ANY = 2;
    public int where = -1;
    public static final int IN_ASSIGN = 0;
    public static final int IN_KEYWORDS = 1;
    public int how = -1;
    private boolean entryPointCorrect = false;
    private boolean inAssing = false;
    private boolean inFuncDef = false;
    public String methodCall = "";

    public HeuristicFindAttrs(int where, int how, String methodCall, String moduleName, ICompletionState state) {
        this.where = where;
        this.how = how;
        this.methodCall = methodCall;
        this.moduleName = moduleName;
        if (state != null && state.getLookingFor() == 3) {
            this.discoverSelfAttrs = false;
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
    }

    public Object visitCall(Call node) throws Exception {
        if (!this.entryPointCorrect && this.methodCall.length() > 0) {
            this.entryPointCorrect = true;
            String[] c = StringUtils.dotSplit((String)this.methodCall);
            if (node.func instanceof Attribute) {
                Attribute func = (Attribute)node.func;
                if (((NameTok)func.attr).id.equals(c[1]) && func.value instanceof Name) {
                    Name name = (Name)func.value;
                    if (name.id.equals(c[0])) {
                        int i = 0;
                        while (i < node.keywords.length) {
                            this.addToken((SimpleNode)node.keywords[i]);
                            ++i;
                        }
                    }
                }
            }
            this.entryPointCorrect = false;
        }
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        this.stack.push((SimpleNode)node);
        if (!this.entryPointCorrect) {
            this.entryPointCorrect = true;
            this.inFuncDef = true;
            if (this.where == 2) {
                node.traverse((VisitorIF)this);
            } else if (this.where == 1 && node.name.equals("__init__")) {
                node.traverse((VisitorIF)this);
            }
            this.entryPointCorrect = false;
            this.inFuncDef = false;
        }
        this.stack.pop();
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.stack.push((SimpleNode)node);
        Object r = super.visitClassDef(node);
        this.stack.pop();
        return r;
    }

    public Object visitAssign(Assign node) throws Exception {
        if (this.how == 0) {
            this.inAssing = true;
            int i = 0;
            while (i < node.targets.length) {
                if (node.targets[i] instanceof Attribute) {
                    this.visitAttribute((Attribute)node.targets[i]);
                } else if (node.targets[i] instanceof Name && !this.inFuncDef) {
                    String id = ((Name)node.targets[i]).id;
                    if (id != null) {
                        this.addToken((SimpleNode)node.targets[i]);
                    }
                } else if (node.targets[i] instanceof Tuple && !this.inFuncDef) {
                    Tuple tuple = (Tuple)node.targets[i];
                    exprType[] exprTypeArray = tuple.elts;
                    int n = tuple.elts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id;
                        exprType t = exprTypeArray[n2];
                        if (t instanceof Name && (id = ((Name)t).id) != null) {
                            this.addToken((SimpleNode)t);
                        }
                        ++n2;
                    }
                }
                ++i;
            }
            this.inAssing = false;
        }
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        String id;
        if (this.how == 0 && this.inAssing && node.value instanceof Name && (id = ((Name)node.value).id) != null) {
            if (this.discoverSelfAttrs) {
                if (id.equals("self")) {
                    this.addToken((SimpleNode)node);
                }
            } else if (id.equals("cls")) {
                this.addToken((SimpleNode)node);
            }
        }
        return null;
    }

    public Object visitIf(If node) throws Exception {
        node.traverse((VisitorIF)this);
        return null;
    }
}

