/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.REF;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleRunner;

public class PythonShell
extends AbstractShell {
    public PythonShell() throws IOException, CoreException {
        super(PydevPlugin.getScriptWithinPySrc("pycompletionserver.py"));
    }

    protected synchronized String createServerProcess(int pWrite, int pRead) throws IOException {
        String interpreter = PydevPlugin.getPythonInterpreterManager().getDefaultInterpreter();
        File file = new File(interpreter);
        if (!file.exists()) {
            throw new RuntimeException("The interpreter location found does not exist. " + interpreter);
        }
        if (file.isDirectory()) {
            throw new RuntimeException("The interpreter location found is a directory. " + interpreter);
        }
        String execMsg = REF.isWindowsPlatform() ? String.valueOf(interpreter) + " \"" + REF.getFileAbsolutePath((File)this.serverFile) + "\" " + pWrite + " " + pRead : String.valueOf(interpreter) + " " + REF.getFileAbsolutePath((File)this.serverFile) + " " + pWrite + " " + pRead;
        String[] parameters = new String[]{interpreter, REF.getFileAbsolutePath((File)this.serverFile), "" + pWrite, "" + pRead};
        this.process = SimpleRunner.createProcess(parameters, this.serverFile.getParentFile());
        return execMsg;
    }
}

