/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.simpleassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.editor.codecompletion.PythonCompletionProcessor;
import org.python.pydev.editor.simpleassist.ISimpleAssistParticipant;
import org.python.pydev.plugin.PydevPlugin;

public class SimpleAssistProcessor
implements IContentAssistProcessor {
    public static final char[] ALL_ASCII_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_'};
    private static final int SHOW_SIMPLE = 1;
    private static final int SHOW_DEFAULT = 2;
    private int whatToShow = 1;
    private PyEdit edit;
    private PythonCompletionProcessor defaultPythonProcessor;
    private PyContentAssistant assistant;
    private List<ISimpleAssistParticipant> participants;
    private boolean lastCompletionAutoActivated;
    private static volatile boolean useAutocompleteOnAllAsciiCharsCache;
    private static volatile char[] autoActivationCharsCache;
    private static volatile boolean listenerToClearAutoActivationAlreadySetup;

    static {
        listenerToClearAutoActivationAlreadySetup = false;
    }

    public void startCycle() {
        this.whatToShow = 1;
    }

    public void doCycle() {
        if (this.whatToShow == 1) {
            this.whatToShow = 2;
        }
    }

    public void updateStatus() {
        if (this.whatToShow == 1) {
            this.assistant.setIterationStatusMessage("Press %s for default completions.");
        }
    }

    public SimpleAssistProcessor(PyEdit edit, PythonCompletionProcessor defaultPythonProcessor, final PyContentAssistant assistant) {
        this.edit = edit;
        this.defaultPythonProcessor = defaultPythonProcessor;
        this.assistant = assistant;
        this.participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_simpleassist");
        assistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                SimpleAssistProcessor.this.startCycle();
                SimpleAssistProcessor.this.lastCompletionAutoActivated = assistant.getLastCompletionAutoActivated();
                if (!SimpleAssistProcessor.this.lastCompletionAutoActivated) {
                    SimpleAssistProcessor.this.doCycle();
                }
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (this.showDefault()) {
            return this.defaultPythonProcessor.computeCompletionProposals(viewer, offset);
        }
        this.updateStatus();
        IDocument doc = viewer.getDocument();
        String[] strs = PySelection.getActivationTokenAndQual((IDocument)doc, (int)offset, (boolean)false);
        String activationToken = strs[0];
        String qualifier = strs[1];
        PySelection ps = new PySelection((ITextEditor)this.edit);
        ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();
        Iterator<ISimpleAssistParticipant> iterator = this.participants.iterator();
        while (iterator.hasNext()) {
            ISimpleAssistParticipant participant = iterator.next();
            results.addAll(participant.computeCompletionProposals(activationToken, qualifier, ps, this.edit, offset));
        }
        this.doCycle();
        if (results.size() == 0) {
            if (!this.lastCompletionAutoActivated || this.defaultAutoActivated(viewer, offset) || useAutocompleteOnAllAsciiCharsCache) {
                return this.defaultPythonProcessor.computeCompletionProposals(viewer, offset);
            }
            return new ICompletionProposal[0];
        }
        Collections.sort(results, IPyCodeCompletion.PROPOSAL_COMPARATOR);
        return results.toArray(new ICompletionProposal[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean defaultAutoActivated(ITextViewer viewer, int offset) {
        try {
            char docChar = viewer.getDocument().getChar(offset - 1);
            char[] cArray = this.defaultPythonProcessor.getCompletionProposalAutoActivationCharacters();
            int n = cArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                char c = cArray[n2];
                if (c == docChar) {
                    return true;
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private boolean showDefault() {
        return this.whatToShow == 2 || this.participants.size() == 0;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        if (this.showDefault()) {
            return this.defaultPythonProcessor.computeContextInformation(viewer, offset);
        }
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return SimpleAssistProcessor.getStaticAutoActivationCharacters(this.defaultPythonProcessor.getCompletionProposalAutoActivationCharacters(), this.participants.size());
    }

    public static synchronized char[] getStaticAutoActivationCharacters(char[] defaultChars, int participantsLen) {
        if (!listenerToClearAutoActivationAlreadySetup) {
            PydevPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    autoActivationCharsCache = null;
                }
            });
            listenerToClearAutoActivationAlreadySetup = true;
        }
        if (autoActivationCharsCache == null) {
            char[] c2;
            char[] defaultAutoActivationCharacters = defaultChars;
            boolean bl = useAutocompleteOnAllAsciiCharsCache = PyCodeCompletionPreferencesPage.useAutocompleteOnAllAsciiChars() && PyCodeCompletionPreferencesPage.useAutocomplete();
            if (participantsLen == 0 && !useAutocompleteOnAllAsciiCharsCache) {
                c2 = defaultAutoActivationCharacters;
            } else {
                c2 = new char[ALL_ASCII_CHARS.length + defaultAutoActivationCharacters.length];
                System.arraycopy(ALL_ASCII_CHARS, 0, c2, 0, ALL_ASCII_CHARS.length);
                System.arraycopy(defaultAutoActivationCharacters, 0, c2, ALL_ASCII_CHARS.length, defaultAutoActivationCharacters.length);
            }
            autoActivationCharsCache = c2;
        }
        return autoActivationCharsCache;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        if (this.showDefault()) {
            return this.defaultPythonProcessor.getErrorMessage();
        }
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        IContextInformationValidator defaultContextInformationValidator = this.defaultPythonProcessor.getContextInformationValidator();
        return new ContextInformationDelegator(defaultContextInformationValidator);
    }

    private class ContextInformationDelegator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        private final IContextInformationValidator defaultContextInformationValidator;

        private ContextInformationDelegator(IContextInformationValidator defaultContextInformationValidator) {
            Assert.isTrue((boolean)(defaultContextInformationValidator instanceof IContextInformationPresenter));
            this.defaultContextInformationValidator = defaultContextInformationValidator;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.defaultContextInformationValidator.install(info, viewer, offset);
        }

        public boolean isContextInformationValid(int offset) {
            if (SimpleAssistProcessor.this.showDefault()) {
                return this.defaultContextInformationValidator.isContextInformationValid(offset);
            }
            return true;
        }

        public boolean updatePresentation(int offset, TextPresentation presentation) {
            return ((IContextInformationPresenter)this.defaultContextInformationValidator).updatePresentation(offset, presentation);
        }
    }
}

